/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.DefaultPool;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pool;

public class PoolManager {
    private final ObjectMap<Class<?>, Pool<?>> typePools = new ObjectMap();

    public <T> void addPool(Class<T> poolClass, DefaultPool.PoolSupplier<T> poolSupplier) {
        this.addPool(poolClass, new DefaultPool<T>(poolSupplier));
    }

    public <T> void addPool(Class<T> poolClass, Pool<T> pool) {
        Pool<T> oldPool = this.typePools.put(poolClass, pool);
        if (oldPool != null) {
            throw new GdxRuntimeException("Attempt to add pool with already existing class: " + poolClass + ", register using PoolManager#addPool(" + poolClass.getSimpleName() + ", " + poolClass.getSimpleName() + "::new)");
        }
    }

    public <T> Pool<T> getPool(Class<T> clazz) {
        Pool<?> pool = this.typePools.get(clazz);
        if (pool == null) {
            throw new GdxRuntimeException("Attempt to get pool with unknown class: " + clazz + ", register using PoolManager#addPool(" + clazz.getSimpleName() + "::new)");
        }
        return pool;
    }

    public <T> Pool<T> getPoolOrNull(Class<T> clazz) {
        return this.typePools.get(clazz);
    }

    public <T> T obtain(Class<T> clazz) {
        Pool<?> pool = this.typePools.get(clazz);
        if (pool == null) {
            throw new GdxRuntimeException("Attempt to get pooled object with unknown class: " + clazz + ", register using PoolManager#addPool(" + clazz.getSimpleName() + "::new)");
        }
        return (T)pool.obtain();
    }

    public <T> void free(T object) {
        Pool<?> pool = this.typePools.get(object.getClass());
        if (pool == null) {
            throw new GdxRuntimeException("Attempt to free pooled object with unknown class: " + object.getClass() + ", register using PoolManager#addPool(" + object.getClass().getSimpleName() + "::new)");
        }
        pool.free(object);
    }
}

