/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import java.nio.CharBuffer;
import java.util.Arrays;

public class CharArray
implements Appendable,
CharSequence {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public char[] items;
    public int size;
    public boolean ordered;

    public CharArray() {
        this(true, 16);
    }

    public CharArray(boolean ordered, int capacity) {
        this.ordered = ordered;
        this.items = new char[capacity];
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
    }

    public char[] ensureCapacity(int additionalCapacity) {
        if (additionalCapacity < 0) {
            throw new IllegalArgumentException("additionalCapacity must be >= 0: " + additionalCapacity);
        }
        int sizeNeeded = this.size + additionalCapacity;
        if (sizeNeeded - this.items.length > 0) {
            this.resizeBuffer(sizeNeeded);
        }
        return this.items;
    }

    private void require(int additionalCapacity) {
        int sizeNeeded = this.size + additionalCapacity;
        if (sizeNeeded - this.items.length > 0) {
            this.resizeBuffer(sizeNeeded);
        }
    }

    private void resizeBuffer(int minCapacity) {
        int oldCapacity = this.items.length;
        int newCapacity = (oldCapacity >> 1) + oldCapacity + 2;
        if ((newCapacity ^ Integer.MIN_VALUE) < (minCapacity ^ Integer.MIN_VALUE)) {
            newCapacity = minCapacity;
        }
        if ((newCapacity ^ Integer.MIN_VALUE) > -9) {
            if (minCapacity < 0) {
                throw new RuntimeException("Unable to allocate array size: " + ((long)minCapacity & 0xFFFFFFFFL));
            }
            newCapacity = Math.max(minCapacity, 0x7FFFFFF7);
        }
        this.resize(newCapacity);
    }

    protected char[] resize(int newSize) {
        this.items = Arrays.copyOf(this.items, newSize);
        return this.items;
    }

    @Override
    public CharArray append(char value) {
        this.require(1);
        this.items[this.size++] = value;
        return this;
    }

    public CharArray append(CharBuffer str) {
        if (str == null) {
            this.appendNull();
        } else {
            this.append(str, 0, str.length());
        }
        return this;
    }

    public CharArray append(CharBuffer buf, int start, int end) {
        if (buf == null) {
            return this.appendNull();
        }
        if (buf.hasArray()) {
            int totalLength = buf.remaining();
            if (start < 0 || end < 0 || start > end || end > totalLength) {
                throw new IndexOutOfBoundsException();
            }
            int length = end - start;
            this.require(length);
            System.arraycopy(buf.array(), buf.arrayOffset() + buf.position() + start, this.items, this.size, length);
            this.size += length;
        } else {
            this.append(buf.toString(), start, end);
        }
        return this;
    }

    @Override
    public CharArray append(CharSequence seq) {
        if (seq == null) {
            return this.appendNull();
        }
        if (seq instanceof CharArray) {
            return this.append((CharArray)seq);
        }
        if (seq instanceof StringBuilder) {
            return this.append((StringBuilder)seq);
        }
        if (seq instanceof StringBuffer) {
            return this.append((StringBuffer)seq);
        }
        if (seq instanceof CharBuffer) {
            return this.append((CharBuffer)seq);
        }
        return this.append(seq.toString());
    }

    @Override
    public CharArray append(CharSequence seq, int start, int end) {
        if (seq == null) {
            return this.appendNull();
        }
        if (start < 0 || end < 0 || start > end || end > seq.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this.append(seq.toString(), start, end);
    }

    public CharArray append(String str) {
        if (str == null) {
            this.appendNull();
        } else {
            int length = str.length();
            this.require(length);
            str.getChars(0, length, this.items, this.size);
            this.size += length;
        }
        return this;
    }

    public CharArray append(String str, int start, int end) {
        if (str == null) {
            return this.appendNull();
        }
        if (start < 0 || end < 0 || start > end || end > str.length()) {
            throw new IndexOutOfBoundsException();
        }
        int length = end - start;
        if (length > 0) {
            this.require(length);
            str.getChars(start, end, this.items, this.size);
            this.size += length;
        }
        return this;
    }

    public CharArray append(StringBuffer str) {
        if (str == null) {
            this.appendNull();
        } else {
            this.append(str, 0, str.length());
        }
        return this;
    }

    public CharArray append(StringBuffer str, int start, int end) {
        if (str == null) {
            return this.appendNull();
        }
        if (start < 0 || end < 0 || start > end || end > str.length()) {
            throw new IndexOutOfBoundsException();
        }
        int length = end - start;
        if (length > 0) {
            this.require(length);
            str.getChars(start, end, this.items, this.size);
            this.size += length;
        }
        return this;
    }

    public CharArray append(StringBuilder str) {
        if (str == null) {
            this.appendNull();
        } else {
            this.append(str, 0, str.length());
        }
        return this;
    }

    public CharArray append(StringBuilder str, int start, int end) {
        if (str == null) {
            return this.appendNull();
        }
        if (start < 0 || end < 0 || start > end || end > str.length()) {
            throw new IndexOutOfBoundsException();
        }
        int length = end - start;
        if (length > 0) {
            this.require(length);
            str.getChars(start, end, this.items, this.size);
            this.size += length;
        }
        return this;
    }

    public CharArray append(CharArray str) {
        if (str == null) {
            this.appendNull();
        } else {
            this.append(str, 0, str.size);
        }
        return this;
    }

    public CharArray append(CharArray str, int start, int end) {
        if (str == null) {
            return this.appendNull();
        }
        if (start < 0 || end < 0 || start > end || end > str.size) {
            throw new IndexOutOfBoundsException();
        }
        int length = end - start;
        if (length > 0) {
            this.require(length);
            str.getChars(start, end, this.items, this.size);
            this.size += length;
        }
        return this;
    }

    public CharArray appendNull() {
        this.require(4);
        int length = this.size;
        this.items[length] = 110;
        this.items[length + 1] = 117;
        this.items[length + 2] = 108;
        this.items[length + 3] = 108;
        this.size = length + 4;
        return this;
    }

    @Override
    public char charAt(int index) {
        return this.items[index];
    }

    public void getChars(int start, int end, char[] target, int targetIndex) {
        if (start < 0) {
            throw new IndexOutOfBoundsException("start: " + start);
        }
        if (end < 0 || end > this.size) {
            throw new IndexOutOfBoundsException("end: " + end + ", size: " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("end < start");
        }
        System.arraycopy(this.items, start, target, targetIndex, end - start);
    }

    public int indexOf(char ch, int start) {
        if ((start = Math.max(0, start)) >= this.size) {
            return -1;
        }
        char[] thisBuf = this.items;
        int n = this.size;
        for (int i = start; i < n; ++i) {
            if (thisBuf[i] != ch) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int start) {
        if (str == null) {
            throw new IllegalArgumentException("str cannot be null.");
        }
        if ((start = Math.max(0, start)) >= this.size) {
            return -1;
        }
        int strLen = str.length();
        if (strLen == 1) {
            return this.indexOf(str.charAt(0), start);
        }
        if (strLen == 0) {
            return start;
        }
        if (strLen > this.size) {
            return -1;
        }
        char[] thisBuf = this.items;
        int searchLen = this.size - strLen + 1;
        for (int i = start; i < searchLen; ++i) {
            boolean found = true;
            for (int j = 0; j < strLen && found; ++j) {
                found = str.charAt(j) == thisBuf[i + j];
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int length() {
        return this.size;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        this.validateRange(start, end);
        return this.substring(start, end);
    }

    public String substring(int start, int end) {
        end = this.validateRange(start, end);
        return new String(this.items, start, end - start);
    }

    @Override
    public String toString() {
        if (this.size == 0) {
            return "";
        }
        return new String(this.items, 0, this.size);
    }

    protected int validateRange(int start, int end) {
        if (start < 0) {
            throw new IndexOutOfBoundsException("start: " + start);
        }
        if (end > this.size) {
            throw new IndexOutOfBoundsException("end: " + end + ", size: " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start: " + start + ", end: " + end);
        }
        return end;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof CharArray)) {
            return false;
        }
        CharArray other = (CharArray)object;
        if (!other.ordered) {
            return false;
        }
        int length = this.size;
        if (length != other.size) {
            return false;
        }
        char[] chars = this.items;
        char[] chars2 = other.items;
        for (int i = 0; i < length; ++i) {
            if (chars[i] == chars2[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        char[] chars = this.items;
        int result = 31 + this.size;
        for (int index = 0; index < this.size; ++index) {
            result = 31 * result + chars[index];
        }
        return result;
    }
}

