/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.RandomXS128;
import java.util.Random;

public final class MathUtils {
    public static Random random = new RandomXS128();

    public static float sin(float radians) {
        return (float)Math.sin(radians);
    }

    public static float cos(float radians) {
        return (float)Math.cos(radians);
    }

    public static float sinDeg(float degrees) {
        return (float)Math.sin(degrees * ((float)Math.PI / 180));
    }

    public static float cosDeg(float degrees) {
        return (float)Math.cos(degrees * ((float)Math.PI / 180));
    }

    public static int nextPowerOfTwo(int value) {
        if (value == 0) {
            return 1;
        }
        --value;
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        value |= value >> 16;
        return value + 1;
    }

    public static boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static float lerpAngleDeg(float fromDegrees, float toDegrees, float progress) {
        float delta = ((toDegrees - fromDegrees) % 360.0f + 360.0f + 180.0f) % 360.0f - 180.0f;
        return ((fromDegrees + delta * progress) % 360.0f + 360.0f) % 360.0f;
    }

    public static boolean isEqual(float a, float b, float tolerance) {
        return Math.abs(a - b) <= tolerance;
    }
}

