/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.scenes.scene2d.utils.Selection;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.badlogic.gdx.utils.Array;

public class Tree<N extends Node, V>
extends WidgetGroup {
    private static final Vector2 tmp = new Vector2();
    TreeStyle style;
    final Array<N> rootNodes;
    final Selection<N> selection;
    float ySpacing;
    float iconSpacingLeft;
    float iconSpacingRight;
    float paddingLeft;
    float paddingRight;
    float indentSpacing;
    private float prefWidth;
    private float prefHeight;
    private boolean sizeInvalid;
    private N overNode;

    public void setStyle(TreeStyle style) {
        this.style = style;
        if (this.indentSpacing == 0.0f) {
            this.indentSpacing = this.plusMinusWidth();
        }
    }

    @Override
    public void clearChildren(boolean unfocus) {
        super.clearChildren(unfocus);
        this.setOverNode(null);
        this.rootNodes.clear();
        this.selection.clear();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.sizeInvalid = true;
    }

    private float plusMinusWidth() {
        float width = Math.max(this.style.plus.getMinWidth(), this.style.minus.getMinWidth());
        if (this.style.plusOver != null) {
            width = Math.max(width, this.style.plusOver.getMinWidth());
        }
        if (this.style.minusOver != null) {
            width = Math.max(width, this.style.minusOver.getMinWidth());
        }
        return width;
    }

    private void computeSize() {
        this.sizeInvalid = false;
        this.prefWidth = this.plusMinusWidth();
        this.prefHeight = 0.0f;
        this.computeSize(this.rootNodes, 0.0f, this.prefWidth);
        this.prefWidth += this.paddingLeft + this.paddingRight;
    }

    private void computeSize(Array<N> nodes, float indent, float plusMinusWidth) {
        float ySpacing = this.ySpacing;
        float spacing = this.iconSpacingLeft + this.iconSpacingRight;
        int n = nodes.size;
        for (int i = 0; i < n; ++i) {
            Node node = (Node)nodes.get(i);
            float rowWidth = indent + plusMinusWidth;
            Object actor = node.actor;
            if (actor instanceof Layout) {
                Layout layout = (Layout)actor;
                rowWidth += layout.getPrefWidth();
                node.height = layout.getPrefHeight();
            } else {
                rowWidth += ((Actor)actor).getWidth();
                node.height = ((Actor)actor).getHeight();
            }
            if (node.icon != null) {
                rowWidth += spacing + node.icon.getMinWidth();
                node.height = Math.max(node.height, node.icon.getMinHeight());
            }
            this.prefWidth = Math.max(this.prefWidth, rowWidth);
            this.prefHeight += node.height + ySpacing;
            if (!node.expanded) continue;
            this.computeSize(node.children, indent + this.indentSpacing, plusMinusWidth);
        }
    }

    @Override
    public void layout() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        this.layout(this.rootNodes, this.paddingLeft, this.getHeight() - this.ySpacing / 2.0f, this.plusMinusWidth());
    }

    private float layout(Array<N> nodes, float indent, float y, float plusMinusWidth) {
        float ySpacing = this.ySpacing;
        float iconSpacingLeft = this.iconSpacingLeft;
        float spacing = iconSpacingLeft + this.iconSpacingRight;
        int n = nodes.size;
        for (int i = 0; i < n; ++i) {
            Node node = (Node)nodes.get(i);
            float x = indent + plusMinusWidth;
            x = node.icon != null ? (x += spacing + node.icon.getMinWidth()) : (x += iconSpacingLeft);
            if (node.actor instanceof Layout) {
                ((Layout)node.actor).pack();
            }
            ((Actor)node.actor).setPosition(x, y -= node.getHeight());
            y -= ySpacing;
            if (!node.expanded) continue;
            y = this.layout(node.children, indent + this.indentSpacing, y, plusMinusWidth);
        }
        return y;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.drawBackground(batch, parentAlpha);
        Color color = this.getColor();
        float a = color.a * parentAlpha;
        batch.setColor(color.r, color.g, color.b, a);
        this.drawIcons(batch, color.r, color.g, color.b, a, null, this.rootNodes, this.paddingLeft, this.plusMinusWidth());
        super.draw(batch, parentAlpha);
    }

    protected void drawBackground(Batch batch, float parentAlpha) {
        if (this.style.background != null) {
            Color color = this.getColor();
            batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
            this.style.background.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    protected float drawIcons(Batch batch, float r, float g, float b, float a, N parent, Array<N> nodes, float indent, float plusMinusWidth) {
        Rectangle cullingArea = this.getCullingArea();
        float cullBottom = 0.0f;
        float cullTop = 0.0f;
        if (cullingArea != null) {
            cullBottom = cullingArea.y;
            cullTop = cullBottom + cullingArea.height;
        }
        TreeStyle style = this.style;
        float x = this.getX();
        float y = this.getY();
        float expandX = x + indent;
        float iconX = expandX + plusMinusWidth + this.iconSpacingLeft;
        float actorY = 0.0f;
        int n = nodes.size;
        for (int i = 0; i < n; ++i) {
            Node node = (Node)nodes.get(i);
            Object actor = node.actor;
            actorY = ((Actor)actor).getY();
            float height = node.height;
            if (cullingArea == null || actorY + height >= cullBottom && actorY <= cullTop) {
                if (this.selection.contains(node) && style.selection != null) {
                    this.drawSelection(node, style.selection, batch, x, y + actorY - this.ySpacing / 2.0f, this.getWidth(), height + this.ySpacing);
                } else if (node == this.overNode && style.over != null) {
                    this.drawOver(node, style.over, batch, x, y + actorY - this.ySpacing / 2.0f, this.getWidth(), height + this.ySpacing);
                }
                if (node.icon != null) {
                    float iconY = y + actorY + (float)Math.round((height - node.icon.getMinHeight()) / 2.0f);
                    Color actorColor = ((Actor)actor).getColor();
                    batch.setColor(actorColor.r, actorColor.g, actorColor.b, actorColor.a * a);
                    this.drawIcon(node, node.icon, batch, iconX, iconY);
                    batch.setColor(r, g, b, a);
                }
                if (node.children.size > 0) {
                    Drawable expandIcon = this.getExpandIcon(node, iconX);
                    float iconY = y + actorY + (float)Math.round((height - expandIcon.getMinHeight()) / 2.0f);
                    this.drawExpandIcon(node, expandIcon, batch, expandX, iconY);
                }
            } else if (actorY < cullBottom) break;
            if (!node.expanded || node.children.size <= 0) continue;
            this.drawIcons(batch, r, g, b, a, node, node.children, indent + this.indentSpacing, plusMinusWidth);
        }
        return actorY;
    }

    protected void drawSelection(N node, Drawable selection, Batch batch, float x, float y, float width, float height) {
        selection.draw(batch, x, y, width, height);
    }

    protected void drawOver(N node, Drawable over, Batch batch, float x, float y, float width, float height) {
        over.draw(batch, x, y, width, height);
    }

    protected void drawExpandIcon(N node, Drawable expandIcon, Batch batch, float x, float y) {
        expandIcon.draw(batch, x, y, expandIcon.getMinWidth(), expandIcon.getMinHeight());
    }

    protected void drawIcon(N node, Drawable icon, Batch batch, float x, float y) {
        icon.draw(batch, x, y, icon.getMinWidth(), icon.getMinHeight());
    }

    protected Drawable getExpandIcon(N node, float iconX) {
        float mouseX;
        if (node == this.overNode && Gdx.app.getType() == Application.ApplicationType.Desktop && (!this.selection.getMultiple() || !UIUtils.ctrl() && !UIUtils.shift()) && (mouseX = this.screenToLocalCoordinates((Vector2)Tree.tmp.set((float)((float)Gdx.input.getX()), (float)0.0f)).x + this.getX()) >= 0.0f && mouseX < iconX) {
            Drawable icon;
            Drawable drawable = icon = ((Node)node).expanded ? this.style.minusOver : this.style.plusOver;
            if (icon != null) {
                return icon;
            }
        }
        return ((Node)node).expanded ? this.style.minus : this.style.plus;
    }

    public TreeStyle getStyle() {
        return this.style;
    }

    public void setOverNode(N overNode) {
        this.overNode = overNode;
    }

    @Override
    public float getPrefWidth() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefWidth;
    }

    @Override
    public float getPrefHeight() {
        if (this.sizeInvalid) {
            this.computeSize();
        }
        return this.prefHeight;
    }

    public static class TreeStyle {
        public Drawable plus;
        public Drawable minus;
        public Drawable plusOver;
        public Drawable minusOver;
        public Drawable over;
        public Drawable selection;
        public Drawable background;

        public TreeStyle() {
        }

        public TreeStyle(TreeStyle style) {
            this.plus = style.plus;
            this.minus = style.minus;
            this.plusOver = style.plusOver;
            this.minusOver = style.minusOver;
            this.over = style.over;
            this.selection = style.selection;
            this.background = style.background;
        }
    }

    public static abstract class Node<N extends Node, V, A extends Actor> {
        A actor;
        final Array<N> children = new Array(0);
        boolean selectable = true;
        boolean expanded;
        Drawable icon;
        float height;

        public float getHeight() {
            return this.height;
        }
    }
}

