/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.IntBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;

public final class ContextAttribs {
    private int majorVersion;
    private int minorVersion;
    private int profileMask;
    private int contextFlags;
    private int contextResetNotificationStrategy = 33377;
    private int contextReleaseBehavior = 8344;
    private int layerPlane;

    public ContextAttribs() {
        this(1, 0);
    }

    public ContextAttribs(int majorVersion, int minorVersion) {
        this(majorVersion, minorVersion, 0, 0);
    }

    public ContextAttribs(int majorVersion, int minorVersion, int profileMask, int contextFlags) {
        if (majorVersion < 0 || 4 < majorVersion || minorVersion < 0 || majorVersion == 4 && 5 < minorVersion || majorVersion == 3 && 3 < minorVersion || majorVersion == 2 && 1 < minorVersion || majorVersion == 1 && 5 < minorVersion) {
            throw new IllegalArgumentException("Invalid OpenGL version specified: " + majorVersion + '.' + minorVersion);
        }
        if (LWJGLUtil.CHECKS) {
            if (1 < Integer.bitCount(profileMask) || 4 < profileMask) {
                throw new IllegalArgumentException("Invalid profile mask specified: " + Integer.toBinaryString(profileMask));
            }
            if (15 < contextFlags) {
                throw new IllegalArgumentException("Invalid context flags specified: " + Integer.toBinaryString(profileMask));
            }
        }
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.profileMask = profileMask;
        this.contextFlags = contextFlags;
    }

    private ContextAttribs(ContextAttribs other) {
        this.majorVersion = other.majorVersion;
        this.minorVersion = other.minorVersion;
        this.profileMask = other.profileMask;
        this.contextFlags = other.contextFlags;
        this.contextResetNotificationStrategy = other.contextResetNotificationStrategy;
        this.contextReleaseBehavior = other.contextReleaseBehavior;
        this.layerPlane = other.layerPlane;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    private boolean hasMask(int mask) {
        return this.profileMask == mask;
    }

    public boolean isProfileCore() {
        return this.hasMask(1);
    }

    private boolean hasFlag(int flag) {
        return (this.contextFlags & flag) != 0;
    }

    public boolean isForwardCompatible() {
        return this.hasFlag(2);
    }

    private ContextAttribs toggleMask(int mask, boolean value) {
        if (value == this.hasMask(mask)) {
            return this;
        }
        ContextAttribs attribs = new ContextAttribs(this);
        attribs.profileMask = value ? mask : 0;
        return attribs;
    }

    public ContextAttribs withProfileCore(boolean profileCore) {
        if (this.majorVersion < 3 || this.majorVersion == 3 && this.minorVersion < 2) {
            throw new IllegalArgumentException("Profiles are only supported on OpenGL version 3.2 or higher.");
        }
        return this.toggleMask(1, profileCore);
    }

    private ContextAttribs toggleFlag(int flag, boolean value) {
        if (value == this.hasFlag(flag)) {
            return this;
        }
        ContextAttribs attribs = new ContextAttribs(this);
        attribs.contextFlags ^= flag;
        return attribs;
    }

    public ContextAttribs withForwardCompatible(boolean forwardCompatible) {
        return this.toggleFlag(2, forwardCompatible);
    }

    IntBuffer getAttribList() {
        if (LWJGLUtil.getPlatform() == 2) {
            return null;
        }
        LinkedHashMap<Integer, Integer> map = new LinkedHashMap<Integer, Integer>(8);
        if (this.majorVersion != 1 || this.minorVersion != 0) {
            map.put(8337, this.majorVersion);
            map.put(8338, this.minorVersion);
        }
        if (this.contextFlags != 0) {
            map.put(8340, this.contextFlags);
        }
        if (this.profileMask != 0) {
            map.put(37158, this.profileMask);
        }
        if (this.contextResetNotificationStrategy != 33377) {
            map.put(33366, this.contextResetNotificationStrategy);
        }
        if (this.contextReleaseBehavior != 8344) {
            map.put(8343, this.contextReleaseBehavior);
        }
        if (this.layerPlane != 0) {
            map.put(8339, this.layerPlane);
        }
        if (map.isEmpty()) {
            return null;
        }
        IntBuffer attribs = BufferUtils.createIntBuffer(map.size() * 2 + 1);
        for (Map.Entry attrib : map.entrySet()) {
            attribs.put((Integer)attrib.getKey()).put((Integer)attrib.getValue());
        }
        attribs.put(0);
        attribs.rewind();
        return attribs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("ContextAttribs:");
        sb.append(" Version=").append(this.majorVersion).append('.').append(this.minorVersion);
        if (this.profileMask != 0) {
            sb.append(", Profile=");
            if (this.hasMask(1)) {
                sb.append("CORE");
            } else if (this.hasMask(2)) {
                sb.append("COMPATIBLITY");
            } else if (this.hasMask(4)) {
                sb.append("ES2");
            } else {
                sb.append("*unknown*");
            }
        }
        if (this.contextFlags != 0) {
            if (this.hasFlag(1)) {
                sb.append(", DEBUG");
            }
            if (this.hasFlag(2)) {
                sb.append(", FORWARD_COMPATIBLE");
            }
            if (this.hasFlag(4)) {
                sb.append(", ROBUST_ACCESS");
            }
            if (this.hasFlag(8)) {
                sb.append(", RESET_ISOLATION");
            }
        }
        if (this.contextResetNotificationStrategy != 33377) {
            sb.append(", LOSE_CONTEXT_ON_RESET");
        }
        if (this.contextReleaseBehavior != 8344) {
            sb.append(", RELEASE_BEHAVIOR_NONE");
        }
        if (this.layerPlane != 0) {
            sb.append(", Layer=").append(this.layerPlane);
        }
        return sb.toString();
    }
}

