/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.NumberUtils;
import com.badlogic.gdx.utils.ShortArray;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.SkeletonAttachment;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import com.esotericsoftware.spine.utils.SkeletonClipping;
import com.esotericsoftware.spine.utils.TwoColorPolygonBatch;

public class SkeletonRenderer {
    private static final short[] quadTriangles = new short[]{0, 1, 2, 2, 3, 0};
    private boolean premultipliedAlpha;
    private final FloatArray vertices = new FloatArray(32);
    private final SkeletonClipping clipper = new SkeletonClipping();
    private VertexEffect vertexEffect;
    private final Vector2 temp = new Vector2();
    private final Vector2 temp2 = new Vector2();
    private final Color temp3 = new Color();
    private final Color temp4 = new Color();
    private final Color temp5 = new Color();
    private final Color temp6 = new Color();

    public void draw(TwoColorPolygonBatch twoColorPolygonBatch, Skeleton skeleton) {
        if (twoColorPolygonBatch == null) {
            throw new IllegalArgumentException("batch cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        Vector2 vector2 = this.temp;
        Vector2 vector22 = this.temp2;
        Color color = this.temp3;
        Color color2 = this.temp4;
        Color color3 = this.temp5;
        Color color4 = this.temp6;
        VertexEffect vertexEffect = this.vertexEffect;
        if (vertexEffect != null) {
            vertexEffect.begin(skeleton);
        }
        boolean bl = this.premultipliedAlpha;
        twoColorPolygonBatch.setPremultipliedAlpha(bl);
        BlendMode blendMode = null;
        int n = 0;
        float[] fArray = null;
        float[] fArray2 = null;
        short[] sArray = null;
        Color color5 = null;
        Color color6 = skeleton.color;
        float f = color6.r;
        float f2 = color6.g;
        float f3 = color6.b;
        float f4 = color6.a;
        Array<Slot> array = skeleton.drawOrder;
        int n2 = array.size;
        for (int i = 0; i < n2; ++i) {
            Object object;
            Slot slot = array.get(i);
            if (!slot.bone.active) {
                this.clipper.clipEnd(slot);
                continue;
            }
            Texture texture = null;
            int n3 = this.clipper.isClipping() ? 2 : 6;
            Attachment attachment = slot.attachment;
            if (attachment instanceof RegionAttachment) {
                object = (RegionAttachment)attachment;
                n = n3 << 2;
                fArray = this.vertices.items;
                ((RegionAttachment)object).computeWorldVertices(slot.getBone(), fArray, 0, n3);
                sArray = quadTriangles;
                texture = ((RegionAttachment)object).getRegion().getTexture();
                fArray2 = ((RegionAttachment)object).getUVs();
                color5 = ((RegionAttachment)object).getColor();
            } else if (attachment instanceof MeshAttachment) {
                object = (MeshAttachment)attachment;
                int n4 = ((VertexAttachment)object).getWorldVerticesLength();
                n = (n4 >> 1) * n3;
                fArray = this.vertices.setSize(n);
                ((VertexAttachment)object).computeWorldVertices(slot, 0, n4, fArray, 0, n3);
                sArray = ((MeshAttachment)object).getTriangles();
                texture = ((MeshAttachment)object).getRegion().getTexture();
                fArray2 = ((MeshAttachment)object).getUVs();
                color5 = ((MeshAttachment)object).getColor();
            } else {
                if (attachment instanceof ClippingAttachment) {
                    object = (ClippingAttachment)attachment;
                    this.clipper.clipStart(slot, (ClippingAttachment)object);
                    continue;
                }
                if (attachment instanceof SkeletonAttachment && (object = ((SkeletonAttachment)attachment).getSkeleton()) != null) {
                    this.draw(twoColorPolygonBatch, (Skeleton)object);
                }
            }
            if (texture != null) {
                float f5;
                object = slot.getColor();
                float f6 = f4 * ((Color)object).a * color5.a * 255.0f;
                float f7 = bl ? f6 : 255.0f;
                BlendMode blendMode2 = slot.data.getBlendMode();
                if (blendMode2 != blendMode) {
                    if (blendMode2 == BlendMode.additive && bl) {
                        blendMode2 = BlendMode.normal;
                        f6 = 0.0f;
                    }
                    blendMode = blendMode2;
                    twoColorPolygonBatch.setBlendFunction(blendMode.getSource(bl), blendMode.getDest());
                }
                float f8 = f * color5.r * f7;
                float f9 = f2 * color5.g * f7;
                float f10 = f3 * color5.b * f7;
                float f11 = NumberUtils.intToFloatColor((int)f6 << 24 | (int)(f10 * ((Color)object).b) << 16 | (int)(f9 * ((Color)object).g) << 8 | (int)(f8 * ((Color)object).r));
                Color color7 = slot.getDarkColor();
                float f12 = f5 = color7 == null ? 0.0f : NumberUtils.intToFloatColor((int)(f10 * color7.b) << 16 | (int)(f9 * color7.g) << 8 | (int)(f8 * color7.r));
                if (this.clipper.isClipping()) {
                    this.clipper.clipTriangles(fArray, n, sArray, sArray.length, fArray2, f11, f5, true);
                    FloatArray floatArray = this.clipper.getClippedVertices();
                    ShortArray shortArray = this.clipper.getClippedTriangles();
                    if (vertexEffect != null) {
                        this.applyVertexEffect(floatArray.items, floatArray.size, 6, f11, f5);
                    }
                    twoColorPolygonBatch.drawTwoColor(texture, floatArray.items, 0, floatArray.size, shortArray.items, 0, shortArray.size);
                } else {
                    int n5;
                    int n6;
                    if (vertexEffect != null) {
                        color.set(NumberUtils.floatToIntColor(f11));
                        color2.set(NumberUtils.floatToIntColor(f5));
                        n6 = 0;
                        n5 = 0;
                        while (n6 < n) {
                            vector2.x = fArray[n6];
                            vector2.y = fArray[n6 + 1];
                            color3.set(color);
                            color4.set(color2);
                            vector22.x = fArray2[n5];
                            vector22.y = fArray2[n5 + 1];
                            vertexEffect.transform(vector2, vector22, color3, color4);
                            fArray[n6] = vector2.x;
                            fArray[n6 + 1] = vector2.y;
                            fArray[n6 + 2] = color3.toFloatBits();
                            fArray[n6 + 3] = color4.toFloatBits();
                            fArray[n6 + 4] = vector22.x;
                            fArray[n6 + 5] = vector22.y;
                            n6 += 6;
                            n5 += 2;
                        }
                    } else {
                        n6 = 2;
                        n5 = 0;
                        while (n6 < n) {
                            fArray[n6] = f11;
                            fArray[n6 + 1] = f5;
                            fArray[n6 + 2] = fArray2[n5];
                            fArray[n6 + 3] = fArray2[n5 + 1];
                            n6 += 6;
                            n5 += 2;
                        }
                    }
                    twoColorPolygonBatch.drawTwoColor(texture, fArray, 0, n, sArray, 0, sArray.length);
                }
            }
            this.clipper.clipEnd(slot);
        }
        this.clipper.clipEnd();
        if (vertexEffect != null) {
            vertexEffect.end();
        }
    }

    private void applyVertexEffect(float[] fArray, int n, int n2, float f, float f2) {
        Vector2 vector2 = this.temp;
        Vector2 vector22 = this.temp2;
        Color color = this.temp3;
        Color color2 = this.temp4;
        Color color3 = this.temp5;
        Color color4 = this.temp6;
        VertexEffect vertexEffect = this.vertexEffect;
        color.set(NumberUtils.floatToIntColor(f));
        color2.set(NumberUtils.floatToIntColor(f2));
        if (n2 == 5) {
            for (int i = 0; i < n; i += n2) {
                vector2.x = fArray[i];
                vector2.y = fArray[i + 1];
                vector22.x = fArray[i + 3];
                vector22.y = fArray[i + 4];
                color3.set(color);
                color4.set(color2);
                vertexEffect.transform(vector2, vector22, color3, color4);
                fArray[i] = vector2.x;
                fArray[i + 1] = vector2.y;
                fArray[i + 2] = color3.toFloatBits();
                fArray[i + 3] = vector22.x;
                fArray[i + 4] = vector22.y;
            }
        } else {
            for (int i = 0; i < n; i += n2) {
                vector2.x = fArray[i];
                vector2.y = fArray[i + 1];
                vector22.x = fArray[i + 4];
                vector22.y = fArray[i + 5];
                color3.set(color);
                color4.set(color2);
                vertexEffect.transform(vector2, vector22, color3, color4);
                fArray[i] = vector2.x;
                fArray[i + 1] = vector2.y;
                fArray[i + 2] = color3.toFloatBits();
                fArray[i + 3] = color4.toFloatBits();
                fArray[i + 4] = vector22.x;
                fArray[i + 5] = vector22.y;
            }
        }
    }

    public void setPremultipliedAlpha(boolean bl) {
        this.premultipliedAlpha = bl;
    }

    public static interface VertexEffect {
        public void begin(Skeleton var1);

        public void transform(Vector2 var1, Vector2 var2, Color var3, Color var4);

        public void end();
    }
}

