/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.DataInput;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.SerializationException;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.EventData;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonJson;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.attachments.AtlasAttachmentLoader;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.AttachmentLoader;
import com.esotericsoftware.spine.attachments.AttachmentType;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.PointAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.VertexAttachment;
import java.io.EOFException;
import java.io.IOException;

public class SkeletonBinary {
    public static final int BONE_ROTATE = 0;
    public static final int BONE_TRANSLATE = 1;
    public static final int BONE_SCALE = 2;
    public static final int BONE_SHEAR = 3;
    public static final int SLOT_ATTACHMENT = 0;
    public static final int SLOT_COLOR = 1;
    public static final int SLOT_TWO_COLOR = 2;
    public static final int PATH_POSITION = 0;
    public static final int PATH_SPACING = 1;
    public static final int PATH_MIX = 2;
    public static final int CURVE_LINEAR = 0;
    public static final int CURVE_STEPPED = 1;
    public static final int CURVE_BEZIER = 2;
    private static final Color tempColor1 = new Color();
    private static final Color tempColor2 = new Color();
    private final AttachmentLoader attachmentLoader;
    private float scale = 1.0f;
    private Array<SkeletonJson.LinkedMesh> linkedMeshes = new Array();

    public SkeletonBinary(TextureAtlas textureAtlas) {
        this.attachmentLoader = new AtlasAttachmentLoader(textureAtlas);
    }

    public SkeletonBinary(AttachmentLoader attachmentLoader) {
        if (attachmentLoader == null) {
            throw new IllegalArgumentException("attachmentLoader cannot be null.");
        }
        this.attachmentLoader = attachmentLoader;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float f) {
        this.scale = f;
    }

    public SkeletonData readSkeletonData(FileHandle fileHandle) {
        if (fileHandle == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        float f = this.scale;
        SkeletonData skeletonData = new SkeletonData();
        skeletonData.name = fileHandle.nameWithoutExtension();
        DataInput dataInput = new DataInput(fileHandle.read(512)){
            private char[] chars;
            {
                this.chars = new char[32];
            }

            @Override
            public String readString() throws IOException {
                int n = this.readInt(true);
                switch (n) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return "";
                    }
                }
                if (this.chars.length < --n) {
                    this.chars = new char[n];
                }
                char[] cArray = this.chars;
                int n2 = 0;
                int n3 = 0;
                block9: while (n3 < n) {
                    int n4 = this.read();
                    switch (n4 >> 4) {
                        case -1: {
                            throw new EOFException();
                        }
                        case 12: 
                        case 13: {
                            cArray[n2++] = (char)((n4 & 0x1F) << 6 | this.read() & 0x3F);
                            n3 += 2;
                            continue block9;
                        }
                        case 14: {
                            cArray[n2++] = (char)((n4 & 0xF) << 12 | (this.read() & 0x3F) << 6 | this.read() & 0x3F);
                            n3 += 3;
                            continue block9;
                        }
                    }
                    cArray[n2++] = (char)n4;
                    ++n3;
                }
                return new String(cArray, 0, n2);
            }
        };
        try {
            Object object;
            BoneData boneData;
            Object object2;
            int n;
            skeletonData.hash = dataInput.readString();
            if (skeletonData.hash.isEmpty()) {
                skeletonData.hash = null;
            }
            skeletonData.version = dataInput.readString();
            if (skeletonData.version.isEmpty()) {
                skeletonData.version = null;
            }
            skeletonData.width = dataInput.readFloat();
            skeletonData.height = dataInput.readFloat();
            boolean bl = dataInput.readBoolean();
            if (bl) {
                skeletonData.fps = dataInput.readFloat();
                skeletonData.imagesPath = dataInput.readString();
                if (skeletonData.imagesPath.isEmpty()) {
                    skeletonData.imagesPath = null;
                }
                skeletonData.audioPath = dataInput.readString();
                if (skeletonData.audioPath.isEmpty()) {
                    skeletonData.audioPath = null;
                }
            }
            int n2 = dataInput.readInt(true);
            for (n = 0; n < n2; ++n) {
                object2 = dataInput.readString();
                boneData = n == 0 ? null : skeletonData.bones.get(dataInput.readInt(true));
                object = new BoneData(n, (String)object2, boneData);
                ((BoneData)object).rotation = dataInput.readFloat();
                ((BoneData)object).x = dataInput.readFloat() * f;
                ((BoneData)object).y = dataInput.readFloat() * f;
                ((BoneData)object).scaleX = dataInput.readFloat();
                ((BoneData)object).scaleY = dataInput.readFloat();
                ((BoneData)object).shearX = dataInput.readFloat();
                ((BoneData)object).shearY = dataInput.readFloat();
                ((BoneData)object).length = dataInput.readFloat() * f;
                ((BoneData)object).transformMode = BoneData.TransformMode.values[dataInput.readInt(true)];
                if (bl) {
                    Color.rgba8888ToColor(((BoneData)object).color, dataInput.readInt());
                }
                skeletonData.bones.add((BoneData)object);
            }
            n2 = dataInput.readInt(true);
            for (n = 0; n < n2; ++n) {
                object2 = dataInput.readString();
                boneData = skeletonData.bones.get(dataInput.readInt(true));
                object = new SlotData(n, (String)object2, boneData);
                Color.rgba8888ToColor(((SlotData)object).color, dataInput.readInt());
                int n3 = dataInput.readInt();
                if (n3 != -1) {
                    ((SlotData)object).darkColor = new Color();
                    Color.rgb888ToColor(((SlotData)object).darkColor, n3);
                }
                ((SlotData)object).attachmentName = dataInput.readString();
                ((SlotData)object).blendMode = BlendMode.values[dataInput.readInt(true)];
                skeletonData.slots.add((SlotData)object);
            }
            n2 = dataInput.readInt(true);
            for (n = 0; n < n2; ++n) {
                object2 = new IkConstraintData(dataInput.readString());
                ((IkConstraintData)object2).order = dataInput.readInt(true);
                int n4 = dataInput.readInt(true);
                for (int i = 0; i < n4; ++i) {
                    ((IkConstraintData)object2).bones.add(skeletonData.bones.get(dataInput.readInt(true)));
                }
                ((IkConstraintData)object2).target = skeletonData.bones.get(dataInput.readInt(true));
                ((IkConstraintData)object2).mix = dataInput.readFloat();
                ((IkConstraintData)object2).bendDirection = dataInput.readByte();
                ((IkConstraintData)object2).compress = dataInput.readBoolean();
                ((IkConstraintData)object2).stretch = dataInput.readBoolean();
                ((IkConstraintData)object2).uniform = dataInput.readBoolean();
                skeletonData.ikConstraints.add((IkConstraintData)object2);
            }
            n2 = dataInput.readInt(true);
            for (n = 0; n < n2; ++n) {
                object2 = new TransformConstraintData(dataInput.readString());
                ((TransformConstraintData)object2).order = dataInput.readInt(true);
                int n5 = dataInput.readInt(true);
                for (int i = 0; i < n5; ++i) {
                    ((TransformConstraintData)object2).bones.add(skeletonData.bones.get(dataInput.readInt(true)));
                }
                ((TransformConstraintData)object2).target = skeletonData.bones.get(dataInput.readInt(true));
                ((TransformConstraintData)object2).local = dataInput.readBoolean();
                ((TransformConstraintData)object2).relative = dataInput.readBoolean();
                ((TransformConstraintData)object2).offsetRotation = dataInput.readFloat();
                ((TransformConstraintData)object2).offsetX = dataInput.readFloat() * f;
                ((TransformConstraintData)object2).offsetY = dataInput.readFloat() * f;
                ((TransformConstraintData)object2).offsetScaleX = dataInput.readFloat();
                ((TransformConstraintData)object2).offsetScaleY = dataInput.readFloat();
                ((TransformConstraintData)object2).offsetShearY = dataInput.readFloat();
                ((TransformConstraintData)object2).rotateMix = dataInput.readFloat();
                ((TransformConstraintData)object2).translateMix = dataInput.readFloat();
                ((TransformConstraintData)object2).scaleMix = dataInput.readFloat();
                ((TransformConstraintData)object2).shearMix = dataInput.readFloat();
                skeletonData.transformConstraints.add((TransformConstraintData)object2);
            }
            n2 = dataInput.readInt(true);
            for (n = 0; n < n2; ++n) {
                object2 = new PathConstraintData(dataInput.readString());
                ((PathConstraintData)object2).order = dataInput.readInt(true);
                int n6 = dataInput.readInt(true);
                for (int i = 0; i < n6; ++i) {
                    ((PathConstraintData)object2).bones.add(skeletonData.bones.get(dataInput.readInt(true)));
                }
                ((PathConstraintData)object2).target = skeletonData.slots.get(dataInput.readInt(true));
                ((PathConstraintData)object2).positionMode = PathConstraintData.PositionMode.values[dataInput.readInt(true)];
                ((PathConstraintData)object2).spacingMode = PathConstraintData.SpacingMode.values[dataInput.readInt(true)];
                ((PathConstraintData)object2).rotateMode = PathConstraintData.RotateMode.values[dataInput.readInt(true)];
                ((PathConstraintData)object2).offsetRotation = dataInput.readFloat();
                ((PathConstraintData)object2).position = dataInput.readFloat();
                if (((PathConstraintData)object2).positionMode == PathConstraintData.PositionMode.fixed) {
                    ((PathConstraintData)object2).position *= f;
                }
                ((PathConstraintData)object2).spacing = dataInput.readFloat();
                if (((PathConstraintData)object2).spacingMode == PathConstraintData.SpacingMode.length || ((PathConstraintData)object2).spacingMode == PathConstraintData.SpacingMode.fixed) {
                    ((PathConstraintData)object2).spacing *= f;
                }
                ((PathConstraintData)object2).rotateMix = dataInput.readFloat();
                ((PathConstraintData)object2).translateMix = dataInput.readFloat();
                skeletonData.pathConstraints.add((PathConstraintData)object2);
            }
            Skin skin = this.readSkin(dataInput, skeletonData, "default", bl);
            if (skin != null) {
                skeletonData.defaultSkin = skin;
                skeletonData.skins.add(skin);
            }
            int n7 = dataInput.readInt(true);
            for (n2 = 0; n2 < n7; ++n2) {
                skeletonData.skins.add(this.readSkin(dataInput, skeletonData, dataInput.readString(), bl));
            }
            n7 = this.linkedMeshes.size;
            for (n2 = 0; n2 < n7; ++n2) {
                Skin skin2;
                SkeletonJson.LinkedMesh linkedMesh = this.linkedMeshes.get(n2);
                Skin skin3 = skin2 = linkedMesh.skin == null ? skeletonData.getDefaultSkin() : skeletonData.findSkin(linkedMesh.skin);
                if (skin2 == null) {
                    throw new SerializationException("Skin not found: " + linkedMesh.skin);
                }
                Attachment attachment = skin2.getAttachment(linkedMesh.slotIndex, linkedMesh.parent);
                if (attachment == null) {
                    throw new SerializationException("Parent mesh not found: " + linkedMesh.parent);
                }
                linkedMesh.mesh.setParentMesh((MeshAttachment)attachment);
                linkedMesh.mesh.updateUVs();
            }
            this.linkedMeshes.clear();
            n7 = dataInput.readInt(true);
            for (n2 = 0; n2 < n7; ++n2) {
                EventData eventData = new EventData(dataInput.readString());
                eventData.intValue = dataInput.readInt(false);
                eventData.floatValue = dataInput.readFloat();
                eventData.stringValue = dataInput.readString();
                eventData.audioPath = dataInput.readString();
                if (eventData.audioPath != null) {
                    eventData.volume = dataInput.readFloat();
                    eventData.balance = dataInput.readFloat();
                }
                skeletonData.events.add(eventData);
            }
            n7 = dataInput.readInt(true);
            for (n2 = 0; n2 < n7; ++n2) {
                this.readAnimation(dataInput, dataInput.readString(), skeletonData);
            }
        }
        catch (IOException iOException) {
            throw new SerializationException("Error reading skeleton file.", iOException);
        }
        finally {
            try {
                dataInput.close();
            }
            catch (IOException iOException) {}
        }
        skeletonData.bones.shrink();
        skeletonData.slots.shrink();
        skeletonData.skins.shrink();
        skeletonData.events.shrink();
        skeletonData.animations.shrink();
        skeletonData.ikConstraints.shrink();
        return skeletonData;
    }

    private Skin readSkin(DataInput dataInput, SkeletonData skeletonData, String string, boolean bl) throws IOException {
        int n = dataInput.readInt(true);
        if (n == 0) {
            return null;
        }
        Skin skin = new Skin(string);
        for (int i = 0; i < n; ++i) {
            int n2 = dataInput.readInt(true);
            int n3 = dataInput.readInt(true);
            for (int j = 0; j < n3; ++j) {
                String string2 = dataInput.readString();
                Attachment attachment = this.readAttachment(dataInput, skeletonData, skin, n2, string2, bl);
                if (attachment == null) continue;
                skin.addAttachment(n2, string2, attachment);
            }
        }
        return skin;
    }

    private Attachment readAttachment(DataInput dataInput, SkeletonData skeletonData, Skin skin, int n, String string, boolean bl) throws IOException {
        float f = this.scale;
        String string2 = dataInput.readString();
        if (string2 == null) {
            string2 = string;
        }
        AttachmentType attachmentType = AttachmentType.values[dataInput.readByte()];
        switch (attachmentType) {
            case region: {
                RegionAttachment regionAttachment;
                String string3 = dataInput.readString();
                float f2 = dataInput.readFloat();
                float f3 = dataInput.readFloat();
                float f4 = dataInput.readFloat();
                float f5 = dataInput.readFloat();
                float f6 = dataInput.readFloat();
                float f7 = dataInput.readFloat();
                float f8 = dataInput.readFloat();
                int n2 = dataInput.readInt();
                if (string3 == null) {
                    string3 = string2;
                }
                if ((regionAttachment = this.attachmentLoader.newRegionAttachment(skin, string2, string3)) == null) {
                    return null;
                }
                regionAttachment.setPath(string3);
                regionAttachment.setX(f3 * f);
                regionAttachment.setY(f4 * f);
                regionAttachment.setScaleX(f5);
                regionAttachment.setScaleY(f6);
                regionAttachment.setRotation(f2);
                regionAttachment.setWidth(f7 * f);
                regionAttachment.setHeight(f8 * f);
                Color.rgba8888ToColor(regionAttachment.getColor(), n2);
                regionAttachment.updateOffset();
                return regionAttachment;
            }
            case boundingbox: {
                int n3 = dataInput.readInt(true);
                Vertices vertices = this.readVertices(dataInput, n3);
                int n4 = bl ? dataInput.readInt() : 0;
                BoundingBoxAttachment boundingBoxAttachment = this.attachmentLoader.newBoundingBoxAttachment(skin, string2);
                if (boundingBoxAttachment == null) {
                    return null;
                }
                boundingBoxAttachment.setWorldVerticesLength(n3 << 1);
                boundingBoxAttachment.setVertices(vertices.vertices);
                boundingBoxAttachment.setBones(vertices.bones);
                if (bl) {
                    Color.rgba8888ToColor(boundingBoxAttachment.getColor(), n4);
                }
                return boundingBoxAttachment;
            }
            case mesh: {
                MeshAttachment meshAttachment;
                String string4 = dataInput.readString();
                int n5 = dataInput.readInt();
                int n6 = dataInput.readInt(true);
                float[] fArray = this.readFloatArray(dataInput, n6 << 1, 1.0f);
                short[] sArray = this.readShortArray(dataInput);
                Vertices vertices = this.readVertices(dataInput, n6);
                int n7 = dataInput.readInt(true);
                short[] sArray2 = null;
                float f9 = 0.0f;
                float f10 = 0.0f;
                if (bl) {
                    sArray2 = this.readShortArray(dataInput);
                    f9 = dataInput.readFloat();
                    f10 = dataInput.readFloat();
                }
                if (string4 == null) {
                    string4 = string2;
                }
                if ((meshAttachment = this.attachmentLoader.newMeshAttachment(skin, string2, string4)) == null) {
                    return null;
                }
                meshAttachment.setPath(string4);
                Color.rgba8888ToColor(meshAttachment.getColor(), n5);
                meshAttachment.setBones(vertices.bones);
                meshAttachment.setVertices(vertices.vertices);
                meshAttachment.setWorldVerticesLength(n6 << 1);
                meshAttachment.setTriangles(sArray);
                meshAttachment.setRegionUVs(fArray);
                meshAttachment.updateUVs();
                meshAttachment.setHullLength(n7 << 1);
                if (bl) {
                    meshAttachment.setEdges(sArray2);
                    meshAttachment.setWidth(f9 * f);
                    meshAttachment.setHeight(f10 * f);
                }
                return meshAttachment;
            }
            case linkedmesh: {
                MeshAttachment meshAttachment;
                String string5 = dataInput.readString();
                int n8 = dataInput.readInt();
                String string6 = dataInput.readString();
                String string7 = dataInput.readString();
                boolean bl2 = dataInput.readBoolean();
                float f11 = 0.0f;
                float f12 = 0.0f;
                if (bl) {
                    f11 = dataInput.readFloat();
                    f12 = dataInput.readFloat();
                }
                if (string5 == null) {
                    string5 = string2;
                }
                if ((meshAttachment = this.attachmentLoader.newMeshAttachment(skin, string2, string5)) == null) {
                    return null;
                }
                meshAttachment.setPath(string5);
                Color.rgba8888ToColor(meshAttachment.getColor(), n8);
                meshAttachment.setInheritDeform(bl2);
                if (bl) {
                    meshAttachment.setWidth(f11 * f);
                    meshAttachment.setHeight(f12 * f);
                }
                this.linkedMeshes.add(new SkeletonJson.LinkedMesh(meshAttachment, string6, n, string7));
                return meshAttachment;
            }
            case path: {
                int n9;
                boolean bl3 = dataInput.readBoolean();
                boolean bl4 = dataInput.readBoolean();
                int n10 = dataInput.readInt(true);
                Vertices vertices = this.readVertices(dataInput, n10);
                float[] fArray = new float[n10 / 3];
                int n11 = fArray.length;
                for (n9 = 0; n9 < n11; ++n9) {
                    fArray[n9] = dataInput.readFloat() * f;
                }
                n9 = bl ? dataInput.readInt() : 0;
                PathAttachment pathAttachment = this.attachmentLoader.newPathAttachment(skin, string2);
                if (pathAttachment == null) {
                    return null;
                }
                pathAttachment.setClosed(bl3);
                pathAttachment.setConstantSpeed(bl4);
                pathAttachment.setWorldVerticesLength(n10 << 1);
                pathAttachment.setVertices(vertices.vertices);
                pathAttachment.setBones(vertices.bones);
                pathAttachment.setLengths(fArray);
                if (bl) {
                    Color.rgba8888ToColor(pathAttachment.getColor(), n9);
                }
                return pathAttachment;
            }
            case point: {
                float f13 = dataInput.readFloat();
                float f14 = dataInput.readFloat();
                float f15 = dataInput.readFloat();
                int n12 = bl ? dataInput.readInt() : 0;
                PointAttachment pointAttachment = this.attachmentLoader.newPointAttachment(skin, string2);
                if (pointAttachment == null) {
                    return null;
                }
                pointAttachment.setX(f14 * f);
                pointAttachment.setY(f15 * f);
                pointAttachment.setRotation(f13);
                if (bl) {
                    Color.rgba8888ToColor(pointAttachment.getColor(), n12);
                }
                return pointAttachment;
            }
            case clipping: {
                int n13 = dataInput.readInt(true);
                int n14 = dataInput.readInt(true);
                Vertices vertices = this.readVertices(dataInput, n14);
                int n15 = bl ? dataInput.readInt() : 0;
                ClippingAttachment clippingAttachment = this.attachmentLoader.newClippingAttachment(skin, string2);
                if (clippingAttachment == null) {
                    return null;
                }
                clippingAttachment.setEndSlot(skeletonData.slots.get(n13));
                clippingAttachment.setWorldVerticesLength(n14 << 1);
                clippingAttachment.setVertices(vertices.vertices);
                clippingAttachment.setBones(vertices.bones);
                if (bl) {
                    Color.rgba8888ToColor(clippingAttachment.getColor(), n15);
                }
                return clippingAttachment;
            }
        }
        return null;
    }

    private Vertices readVertices(DataInput dataInput, int n) throws IOException {
        int n2 = n << 1;
        Vertices vertices = new Vertices();
        if (!dataInput.readBoolean()) {
            vertices.vertices = this.readFloatArray(dataInput, n2, this.scale);
            return vertices;
        }
        FloatArray floatArray = new FloatArray(n2 * 3 * 3);
        IntArray intArray = new IntArray(n2 * 3);
        for (int i = 0; i < n; ++i) {
            int n3 = dataInput.readInt(true);
            intArray.add(n3);
            for (int j = 0; j < n3; ++j) {
                intArray.add(dataInput.readInt(true));
                floatArray.add(dataInput.readFloat() * this.scale);
                floatArray.add(dataInput.readFloat() * this.scale);
                floatArray.add(dataInput.readFloat());
            }
        }
        vertices.vertices = floatArray.toArray();
        vertices.bones = intArray.toArray();
        return vertices;
    }

    private float[] readFloatArray(DataInput dataInput, int n, float f) throws IOException {
        float[] fArray = new float[n];
        if (f == 1.0f) {
            for (int i = 0; i < n; ++i) {
                fArray[i] = dataInput.readFloat();
            }
        } else {
            for (int i = 0; i < n; ++i) {
                fArray[i] = dataInput.readFloat() * f;
            }
        }
        return fArray;
    }

    private short[] readShortArray(DataInput dataInput) throws IOException {
        int n = dataInput.readInt(true);
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = dataInput.readShort();
        }
        return sArray;
    }

    private void readAnimation(DataInput dataInput, String string, SkeletonData skeletonData) {
        Array<Animation.Timeline> array = new Array<Animation.Timeline>();
        float f = this.scale;
        float f2 = 0.0f;
        try {
            int n;
            int n2;
            Animation.Timeline timeline;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9 = dataInput.readInt(true);
            for (n8 = 0; n8 < n9; ++n8) {
                n7 = dataInput.readInt(true);
                n6 = dataInput.readInt(true);
                block16: for (n5 = 0; n5 < n6; ++n5) {
                    n4 = dataInput.readByte();
                    n3 = dataInput.readInt(true);
                    switch (n4) {
                        case 0: {
                            int n10;
                            timeline = new Animation.AttachmentTimeline(n3);
                            ((Animation.AttachmentTimeline)timeline).slotIndex = n7;
                            for (n10 = 0; n10 < n3; ++n10) {
                                ((Animation.AttachmentTimeline)timeline).setFrame(n10, dataInput.readFloat(), dataInput.readString());
                            }
                            array.add(timeline);
                            f2 = Math.max(f2, ((Animation.AttachmentTimeline)timeline).getFrames()[n3 - 1]);
                            continue block16;
                        }
                        case 1: {
                            float f3;
                            int n10;
                            timeline = new Animation.ColorTimeline(n3);
                            ((Animation.ColorTimeline)timeline).slotIndex = n7;
                            for (n10 = 0; n10 < n3; ++n10) {
                                f3 = dataInput.readFloat();
                                Color.rgba8888ToColor(tempColor1, dataInput.readInt());
                                ((Animation.ColorTimeline)timeline).setFrame(n10, f3, SkeletonBinary.tempColor1.r, SkeletonBinary.tempColor1.g, SkeletonBinary.tempColor1.b, SkeletonBinary.tempColor1.a);
                                if (n10 >= n3 - 1) continue;
                                this.readCurve(dataInput, n10, (Animation.CurveTimeline)timeline);
                            }
                            array.add(timeline);
                            f2 = Math.max(f2, ((Animation.ColorTimeline)timeline).getFrames()[(n3 - 1) * 5]);
                            continue block16;
                        }
                        case 2: {
                            float f3;
                            int n10;
                            timeline = new Animation.TwoColorTimeline(n3);
                            ((Animation.TwoColorTimeline)timeline).slotIndex = n7;
                            for (n10 = 0; n10 < n3; ++n10) {
                                f3 = dataInput.readFloat();
                                Color.rgba8888ToColor(tempColor1, dataInput.readInt());
                                Color.rgb888ToColor(tempColor2, dataInput.readInt());
                                ((Animation.TwoColorTimeline)timeline).setFrame(n10, f3, SkeletonBinary.tempColor1.r, SkeletonBinary.tempColor1.g, SkeletonBinary.tempColor1.b, SkeletonBinary.tempColor1.a, SkeletonBinary.tempColor2.r, SkeletonBinary.tempColor2.g, SkeletonBinary.tempColor2.b);
                                if (n10 >= n3 - 1) continue;
                                this.readCurve(dataInput, n10, (Animation.CurveTimeline)timeline);
                            }
                            array.add(timeline);
                            f2 = Math.max(f2, ((Animation.TwoColorTimeline)timeline).getFrames()[(n3 - 1) * 8]);
                            continue block16;
                        }
                    }
                }
            }
            n9 = dataInput.readInt(true);
            for (n8 = 0; n8 < n9; ++n8) {
                n7 = dataInput.readInt(true);
                n6 = dataInput.readInt(true);
                block21: for (n5 = 0; n5 < n6; ++n5) {
                    n4 = dataInput.readByte();
                    n3 = dataInput.readInt(true);
                    switch (n4) {
                        case 0: {
                            timeline = new Animation.RotateTimeline(n3);
                            ((Animation.RotateTimeline)timeline).boneIndex = n7;
                            for (int i = 0; i < n3; ++i) {
                                ((Animation.RotateTimeline)timeline).setFrame(i, dataInput.readFloat(), dataInput.readFloat());
                                if (i >= n3 - 1) continue;
                                this.readCurve(dataInput, i, (Animation.CurveTimeline)timeline);
                            }
                            array.add(timeline);
                            f2 = Math.max(f2, ((Animation.RotateTimeline)timeline).getFrames()[(n3 - 1) * 2]);
                            continue block21;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            float f4 = 1.0f;
                            if (n4 == 2) {
                                timeline = new Animation.ScaleTimeline(n3);
                            } else if (n4 == 3) {
                                timeline = new Animation.ShearTimeline(n3);
                            } else {
                                timeline = new Animation.TranslateTimeline(n3);
                                f4 = f;
                            }
                            ((Animation.TranslateTimeline)timeline).boneIndex = n7;
                            for (int i = 0; i < n3; ++i) {
                                ((Animation.TranslateTimeline)timeline).setFrame(i, dataInput.readFloat(), dataInput.readFloat() * f4, dataInput.readFloat() * f4);
                                if (i >= n3 - 1) continue;
                                this.readCurve(dataInput, i, (Animation.CurveTimeline)timeline);
                            }
                            array.add(timeline);
                            f2 = Math.max(f2, ((Animation.TranslateTimeline)timeline).getFrames()[(n3 - 1) * 3]);
                            continue block21;
                        }
                    }
                }
            }
            n9 = dataInput.readInt(true);
            for (n8 = 0; n8 < n9; ++n8) {
                n7 = dataInput.readInt(true);
                n5 = dataInput.readInt(true);
                Animation.IkConstraintTimeline ikConstraintTimeline = new Animation.IkConstraintTimeline(n5);
                ikConstraintTimeline.ikConstraintIndex = n7;
                for (n4 = 0; n4 < n5; ++n4) {
                    ikConstraintTimeline.setFrame(n4, dataInput.readFloat(), dataInput.readFloat(), dataInput.readByte(), dataInput.readBoolean(), dataInput.readBoolean());
                    if (n4 >= n5 - 1) continue;
                    this.readCurve(dataInput, n4, ikConstraintTimeline);
                }
                array.add(ikConstraintTimeline);
                f2 = Math.max(f2, ikConstraintTimeline.getFrames()[(n5 - 1) * 5]);
            }
            n9 = dataInput.readInt(true);
            for (n8 = 0; n8 < n9; ++n8) {
                n7 = dataInput.readInt(true);
                n5 = dataInput.readInt(true);
                Animation.TransformConstraintTimeline transformConstraintTimeline = new Animation.TransformConstraintTimeline(n5);
                transformConstraintTimeline.transformConstraintIndex = n7;
                for (n4 = 0; n4 < n5; ++n4) {
                    transformConstraintTimeline.setFrame(n4, dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat());
                    if (n4 >= n5 - 1) continue;
                    this.readCurve(dataInput, n4, transformConstraintTimeline);
                }
                array.add(transformConstraintTimeline);
                f2 = Math.max(f2, transformConstraintTimeline.getFrames()[(n5 - 1) * 5]);
            }
            n9 = dataInput.readInt(true);
            for (n8 = 0; n8 < n9; ++n8) {
                n7 = dataInput.readInt(true);
                PathConstraintData pathConstraintData = skeletonData.pathConstraints.get(n7);
                n4 = dataInput.readInt(true);
                block29: for (int i = 0; i < n4; ++i) {
                    n3 = dataInput.readByte();
                    int n11 = dataInput.readInt(true);
                    switch (n3) {
                        case 0: 
                        case 1: {
                            Animation.CurveTimeline curveTimeline;
                            float f5 = 1.0f;
                            if (n3 == 1) {
                                curveTimeline = new Animation.PathConstraintSpacingTimeline(n11);
                                if (pathConstraintData.spacingMode == PathConstraintData.SpacingMode.length || pathConstraintData.spacingMode == PathConstraintData.SpacingMode.fixed) {
                                    f5 = f;
                                }
                            } else {
                                curveTimeline = new Animation.PathConstraintPositionTimeline(n11);
                                if (pathConstraintData.positionMode == PathConstraintData.PositionMode.fixed) {
                                    f5 = f;
                                }
                            }
                            ((Animation.PathConstraintPositionTimeline)curveTimeline).pathConstraintIndex = n7;
                            for (int j = 0; j < n11; ++j) {
                                ((Animation.PathConstraintPositionTimeline)curveTimeline).setFrame(j, dataInput.readFloat(), dataInput.readFloat() * f5);
                                if (j >= n11 - 1) continue;
                                this.readCurve(dataInput, j, curveTimeline);
                            }
                            array.add(curveTimeline);
                            f2 = Math.max(f2, ((Animation.PathConstraintPositionTimeline)curveTimeline).getFrames()[(n11 - 1) * 2]);
                            continue block29;
                        }
                        case 2: {
                            Animation.CurveTimeline curveTimeline = new Animation.PathConstraintMixTimeline(n11);
                            ((Animation.PathConstraintMixTimeline)curveTimeline).pathConstraintIndex = n7;
                            for (int j = 0; j < n11; ++j) {
                                ((Animation.PathConstraintMixTimeline)curveTimeline).setFrame(j, dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat());
                                if (j >= n11 - 1) continue;
                                this.readCurve(dataInput, j, curveTimeline);
                            }
                            array.add(curveTimeline);
                            f2 = Math.max(f2, ((Animation.PathConstraintMixTimeline)curveTimeline).getFrames()[(n11 - 1) * 3]);
                            continue block29;
                        }
                    }
                }
            }
            n9 = dataInput.readInt(true);
            for (n8 = 0; n8 < n9; ++n8) {
                Skin skin = skeletonData.skins.get(dataInput.readInt(true));
                int n12 = dataInput.readInt(true);
                for (int i = 0; i < n12; ++i) {
                    n4 = dataInput.readInt(true);
                    int n13 = dataInput.readInt(true);
                    for (n3 = 0; n3 < n13; ++n3) {
                        VertexAttachment vertexAttachment = (VertexAttachment)skin.getAttachment(n4, dataInput.readString());
                        boolean bl = vertexAttachment.getBones() != null;
                        float[] fArray = vertexAttachment.getVertices();
                        n2 = bl ? fArray.length / 3 * 2 : fArray.length;
                        int n14 = dataInput.readInt(true);
                        Animation.DeformTimeline deformTimeline = new Animation.DeformTimeline(n14);
                        deformTimeline.slotIndex = n4;
                        deformTimeline.attachment = vertexAttachment;
                        for (int j = 0; j < n14; ++j) {
                            float[] fArray2;
                            float f6 = dataInput.readFloat();
                            int n15 = dataInput.readInt(true);
                            if (n15 == 0) {
                                fArray2 = bl ? new float[n2] : fArray;
                            } else {
                                int n16;
                                fArray2 = new float[n2];
                                int n17 = dataInput.readInt(true);
                                n15 += n17;
                                if (f == 1.0f) {
                                    for (n16 = n17; n16 < n15; ++n16) {
                                        fArray2[n16] = dataInput.readFloat();
                                    }
                                } else {
                                    for (n16 = n17; n16 < n15; ++n16) {
                                        fArray2[n16] = dataInput.readFloat() * f;
                                    }
                                }
                                if (!bl) {
                                    int n18 = fArray2.length;
                                    for (n16 = 0; n16 < n18; ++n16) {
                                        int n19 = n16;
                                        fArray2[n19] = fArray2[n19] + fArray[n16];
                                    }
                                }
                            }
                            deformTimeline.setFrame(j, f6, fArray2);
                            if (j >= n14 - 1) continue;
                            this.readCurve(dataInput, j, deformTimeline);
                        }
                        array.add(deformTimeline);
                        f2 = Math.max(f2, deformTimeline.getFrames()[n14 - 1]);
                    }
                }
            }
            n8 = dataInput.readInt(true);
            if (n8 > 0) {
                Animation.DrawOrderTimeline drawOrderTimeline = new Animation.DrawOrderTimeline(n8);
                int n20 = skeletonData.slots.size;
                for (int i = 0; i < n8; ++i) {
                    int n21;
                    float f7 = dataInput.readFloat();
                    n4 = dataInput.readInt(true);
                    int[] nArray = new int[n20];
                    for (int j = n20 - 1; j >= 0; --j) {
                        nArray[j] = -1;
                    }
                    int[] nArray2 = new int[n20 - n4];
                    int n22 = 0;
                    int n23 = 0;
                    for (n21 = 0; n21 < n4; ++n21) {
                        n2 = dataInput.readInt(true);
                        while (n22 != n2) {
                            nArray2[n23++] = n22++;
                        }
                        nArray[n22 + dataInput.readInt((boolean)true)] = n22++;
                    }
                    while (n22 < n20) {
                        nArray2[n23++] = n22++;
                    }
                    for (n21 = n20 - 1; n21 >= 0; --n21) {
                        if (nArray[n21] != -1) continue;
                        nArray[n21] = nArray2[--n23];
                    }
                    drawOrderTimeline.setFrame(i, f7, nArray);
                }
                array.add(drawOrderTimeline);
                f2 = Math.max(f2, drawOrderTimeline.getFrames()[n8 - 1]);
            }
            if ((n = dataInput.readInt(true)) > 0) {
                Animation.EventTimeline eventTimeline = new Animation.EventTimeline(n);
                for (int i = 0; i < n; ++i) {
                    float f8 = dataInput.readFloat();
                    EventData eventData = skeletonData.events.get(dataInput.readInt(true));
                    Event event = new Event(f8, eventData);
                    event.intValue = dataInput.readInt(false);
                    event.floatValue = dataInput.readFloat();
                    String string2 = event.stringValue = dataInput.readBoolean() ? dataInput.readString() : eventData.stringValue;
                    if (event.getData().audioPath != null) {
                        event.volume = dataInput.readFloat();
                        event.balance = dataInput.readFloat();
                    }
                    eventTimeline.setFrame(i, event);
                }
                array.add(eventTimeline);
                f2 = Math.max(f2, eventTimeline.getFrames()[n - 1]);
            }
        }
        catch (IOException iOException) {
            throw new SerializationException("Error reading skeleton file.", iOException);
        }
        array.shrink();
        skeletonData.animations.add(new Animation(string, array, f2));
    }

    private void readCurve(DataInput dataInput, int n, Animation.CurveTimeline curveTimeline) throws IOException {
        switch (dataInput.readByte()) {
            case 1: {
                curveTimeline.setStepped(n);
                break;
            }
            case 2: {
                this.setCurve(curveTimeline, n, dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat());
            }
        }
    }

    void setCurve(Animation.CurveTimeline curveTimeline, int n, float f, float f2, float f3, float f4) {
        curveTimeline.setCurve(n, f, f2, f3, f4);
    }

    static class Vertices {
        int[] bones;
        float[] vertices;

        Vertices() {
        }
    }
}

