/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.ObjectMap;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Constraint;
import com.esotericsoftware.spine.IkConstraint;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.PathConstraint;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.Slot;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.TransformConstraint;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.Updatable;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.utils.SpineUtils;

public class Skeleton {
    final SkeletonData data;
    final Array<Bone> bones;
    final Array<Slot> slots;
    Array<Slot> drawOrder;
    final Array<IkConstraint> ikConstraints;
    final Array<TransformConstraint> transformConstraints;
    final Array<PathConstraint> pathConstraints;
    final Array<Updatable> updateCache = new Array();
    final Array<Bone> updateCacheReset = new Array();
    Skin skin;
    final Color color;
    float time;
    float scaleX = 1.0f;
    float scaleY = 1.0f;
    float x;
    float y;

    public Skeleton(SkeletonData skeletonData) {
        Object object;
        Bone bone;
        if (skeletonData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        this.data = skeletonData;
        this.bones = new Array(skeletonData.bones.size);
        for (BoneData object2 : skeletonData.bones) {
            if (object2.parent == null) {
                bone = new Bone(object2, this, null);
            } else {
                object = this.bones.get(object2.parent.index);
                bone = new Bone(object2, this, (Bone)object);
                ((Bone)object).children.add(bone);
            }
            this.bones.add(bone);
        }
        this.slots = new Array(skeletonData.slots.size);
        this.drawOrder = new Array(skeletonData.slots.size);
        for (SlotData slotData : skeletonData.slots) {
            bone = this.bones.get(slotData.boneData.index);
            object = new Slot(slotData, bone);
            this.slots.add((Slot)object);
            this.drawOrder.add((Slot)object);
        }
        this.ikConstraints = new Array(skeletonData.ikConstraints.size);
        for (IkConstraintData ikConstraintData : skeletonData.ikConstraints) {
            this.ikConstraints.add(new IkConstraint(ikConstraintData, this));
        }
        this.transformConstraints = new Array(skeletonData.transformConstraints.size);
        for (TransformConstraintData transformConstraintData : skeletonData.transformConstraints) {
            this.transformConstraints.add(new TransformConstraint(transformConstraintData, this));
        }
        this.pathConstraints = new Array(skeletonData.pathConstraints.size);
        for (PathConstraintData pathConstraintData : skeletonData.pathConstraints) {
            this.pathConstraints.add(new PathConstraint(pathConstraintData, this));
        }
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.updateCache();
    }

    public Skeleton(Skeleton skeleton) {
        Bone bone;
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = skeleton.data;
        this.bones = new Array(skeleton.bones.size);
        for (Bone object : skeleton.bones) {
            if (object.parent == null) {
                bone = new Bone(object, this, null);
            } else {
                Bone bone2 = this.bones.get(object.parent.data.index);
                bone = new Bone(object, this, bone2);
                bone2.children.add(bone);
            }
            this.bones.add(bone);
        }
        this.slots = new Array(skeleton.slots.size);
        for (Slot slot : skeleton.slots) {
            bone = this.bones.get(slot.bone.data.index);
            this.slots.add(new Slot(slot, bone));
        }
        this.drawOrder = new Array(this.slots.size);
        for (Slot slot : skeleton.drawOrder) {
            this.drawOrder.add(this.slots.get(slot.data.index));
        }
        this.ikConstraints = new Array(skeleton.ikConstraints.size);
        for (IkConstraint ikConstraint : skeleton.ikConstraints) {
            this.ikConstraints.add(new IkConstraint(ikConstraint, this));
        }
        this.transformConstraints = new Array(skeleton.transformConstraints.size);
        for (TransformConstraint transformConstraint : skeleton.transformConstraints) {
            this.transformConstraints.add(new TransformConstraint(transformConstraint, this));
        }
        this.pathConstraints = new Array(skeleton.pathConstraints.size);
        for (PathConstraint pathConstraint : skeleton.pathConstraints) {
            this.pathConstraints.add(new PathConstraint(pathConstraint, this));
        }
        this.skin = skeleton.skin;
        this.color = new Color(skeleton.color);
        this.time = skeleton.time;
        this.scaleX = skeleton.scaleX;
        this.scaleY = skeleton.scaleY;
        this.updateCache();
    }

    public void updateCache() {
        int n;
        int n2;
        Array<Updatable> array = this.updateCache;
        array.clear();
        this.updateCacheReset.clear();
        Array<Bone> array2 = this.bones;
        int n3 = array2.size;
        for (int i = 0; i < n3; ++i) {
            array2.get((int)i).sorted = false;
        }
        Array<IkConstraint> array3 = this.ikConstraints;
        Array<TransformConstraint> array4 = this.transformConstraints;
        Array<PathConstraint> array5 = this.pathConstraints;
        int n4 = array3.size;
        int n5 = array4.size;
        int n6 = array5.size;
        int n7 = n4 + n5 + n6;
        block1: for (n2 = 0; n2 < n7; ++n2) {
            Constraint constraint;
            for (n = 0; n < n4; ++n) {
                constraint = array3.get(n);
                if (constraint.data.order != n2) continue;
                this.sortIkConstraint((IkConstraint)constraint);
                continue block1;
            }
            for (n = 0; n < n5; ++n) {
                constraint = array4.get(n);
                if (((TransformConstraint)constraint).data.order != n2) continue;
                this.sortTransformConstraint((TransformConstraint)constraint);
                continue block1;
            }
            for (n = 0; n < n6; ++n) {
                constraint = array5.get(n);
                if (((PathConstraint)constraint).data.order != n2) continue;
                this.sortPathConstraint((PathConstraint)constraint);
                continue block1;
            }
        }
        n = array2.size;
        for (n2 = 0; n2 < n; ++n2) {
            this.sortBone(array2.get(n2));
        }
    }

    private void sortIkConstraint(IkConstraint ikConstraint) {
        Bone bone;
        Bone bone2 = ikConstraint.target;
        this.sortBone(bone2);
        Array<Bone> array = ikConstraint.bones;
        Bone bone3 = array.first();
        this.sortBone(bone3);
        if (array.size > 1 && !this.updateCache.contains(bone = array.peek(), true)) {
            this.updateCacheReset.add(bone);
        }
        this.updateCache.add(ikConstraint);
        this.sortReset(bone3.children);
        array.peek().sorted = true;
    }

    private void sortPathConstraint(PathConstraint pathConstraint) {
        int n;
        Slot slot = pathConstraint.target;
        int n2 = slot.getData().index;
        Bone bone = slot.bone;
        if (this.skin != null) {
            this.sortPathConstraintAttachment(this.skin, n2, bone);
        }
        if (this.data.defaultSkin != null && this.data.defaultSkin != this.skin) {
            this.sortPathConstraintAttachment(this.data.defaultSkin, n2, bone);
        }
        int n3 = this.data.skins.size;
        for (int i = 0; i < n3; ++i) {
            this.sortPathConstraintAttachment(this.data.skins.get(i), n2, bone);
        }
        Attachment attachment = slot.attachment;
        if (attachment instanceof PathAttachment) {
            this.sortPathConstraintAttachment(attachment, bone);
        }
        Array<Bone> array = pathConstraint.bones;
        int n4 = array.size;
        for (n = 0; n < n4; ++n) {
            this.sortBone(array.get(n));
        }
        this.updateCache.add(pathConstraint);
        for (n = 0; n < n4; ++n) {
            this.sortReset(array.get((int)n).children);
        }
        for (n = 0; n < n4; ++n) {
            array.get((int)n).sorted = true;
        }
    }

    private void sortTransformConstraint(TransformConstraint transformConstraint) {
        int n;
        this.sortBone(transformConstraint.target);
        Array<Bone> array = transformConstraint.bones;
        int n2 = array.size;
        if (transformConstraint.data.local) {
            for (n = 0; n < n2; ++n) {
                Bone bone = array.get(n);
                this.sortBone(bone.parent);
                if (this.updateCache.contains(bone, true)) continue;
                this.updateCacheReset.add(bone);
            }
        } else {
            for (n = 0; n < n2; ++n) {
                this.sortBone(array.get(n));
            }
        }
        this.updateCache.add(transformConstraint);
        for (n = 0; n < n2; ++n) {
            this.sortReset(array.get((int)n).children);
        }
        for (n = 0; n < n2; ++n) {
            array.get((int)n).sorted = true;
        }
    }

    private void sortPathConstraintAttachment(Skin skin, int n, Bone bone) {
        for (ObjectMap.Entry entry : skin.attachments.entries()) {
            if (((Skin.Key)entry.key).slotIndex != n) continue;
            this.sortPathConstraintAttachment((Attachment)entry.value, bone);
        }
    }

    private void sortPathConstraintAttachment(Attachment attachment, Bone bone) {
        if (!(attachment instanceof PathAttachment)) {
            return;
        }
        int[] nArray = ((PathAttachment)attachment).getBones();
        if (nArray == null) {
            this.sortBone(bone);
        } else {
            Array<Bone> array = this.bones;
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                int n3 = nArray[n++];
                n3 += n;
                while (n < n3) {
                    this.sortBone(array.get(nArray[n++]));
                }
            }
        }
    }

    private void sortBone(Bone bone) {
        if (bone.sorted) {
            return;
        }
        Bone bone2 = bone.parent;
        if (bone2 != null) {
            this.sortBone(bone2);
        }
        bone.sorted = true;
        this.updateCache.add(bone);
    }

    private void sortReset(Array<Bone> array) {
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Bone bone = array.get(i);
            if (bone.sorted) {
                this.sortReset(bone.children);
            }
            bone.sorted = false;
        }
    }

    public void updateWorldTransform() {
        Array<Bone> array = this.updateCacheReset;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Bone bone = array.get(i);
            bone.ax = bone.x;
            bone.ay = bone.y;
            bone.arotation = bone.rotation;
            bone.ascaleX = bone.scaleX;
            bone.ascaleY = bone.scaleY;
            bone.ashearX = bone.shearX;
            bone.ashearY = bone.shearY;
            bone.appliedValid = true;
        }
        Array<Updatable> array2 = this.updateCache;
        int n2 = array2.size;
        for (n = 0; n < n2; ++n) {
            array2.get(n).update();
        }
    }

    public void updateWorldTransform(Bone bone) {
        Array<Bone> array = this.updateCacheReset;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Bone bone2 = array.get(i);
            bone2.ax = bone2.x;
            bone2.ay = bone2.y;
            bone2.arotation = bone2.rotation;
            bone2.ascaleX = bone2.scaleX;
            bone2.ascaleY = bone2.scaleY;
            bone2.ashearX = bone2.shearX;
            bone2.ashearY = bone2.shearY;
            bone2.appliedValid = true;
        }
        Bone bone3 = this.getRootBone();
        float f = bone.a;
        float f2 = bone.b;
        float f3 = bone.c;
        float f4 = bone.d;
        bone3.worldX = f * this.x + f2 * this.y + bone.worldX;
        bone3.worldY = f3 * this.x + f4 * this.y + bone.worldY;
        float f5 = bone3.rotation + 90.0f + bone3.shearY;
        float f6 = SpineUtils.cosDeg(bone3.rotation + bone3.shearX) * bone3.scaleX;
        float f7 = SpineUtils.cosDeg(f5) * bone3.scaleY;
        float f8 = SpineUtils.sinDeg(bone3.rotation + bone3.shearX) * bone3.scaleX;
        float f9 = SpineUtils.sinDeg(f5) * bone3.scaleY;
        bone3.a = (f * f6 + f2 * f8) * this.scaleX;
        bone3.b = (f * f7 + f2 * f9) * this.scaleX;
        bone3.c = (f3 * f6 + f4 * f8) * this.scaleY;
        bone3.d = (f3 * f7 + f4 * f9) * this.scaleY;
        Array<Updatable> array2 = this.updateCache;
        int n2 = array2.size;
        for (int i = 0; i < n2; ++i) {
            Updatable updatable = array2.get(i);
            if (updatable == bone3) continue;
            updatable.update();
        }
    }

    public void setToSetupPose() {
        this.setBonesToSetupPose();
        this.setSlotsToSetupPose();
    }

    public void setBonesToSetupPose() {
        Object object;
        Array<Bone> array = this.bones;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            array.get(i).setToSetupPose();
        }
        Array<IkConstraint> array2 = this.ikConstraints;
        int n2 = array2.size;
        for (n = 0; n < n2; ++n) {
            IkConstraint ikConstraint = array2.get(n);
            ikConstraint.mix = ikConstraint.data.mix;
            ikConstraint.bendDirection = ikConstraint.data.bendDirection;
            ikConstraint.compress = ikConstraint.data.compress;
            ikConstraint.stretch = ikConstraint.data.stretch;
        }
        Array<TransformConstraint> array3 = this.transformConstraints;
        int n3 = array3.size;
        for (n2 = 0; n2 < n3; ++n2) {
            TransformConstraint transformConstraint = array3.get(n2);
            object = transformConstraint.data;
            transformConstraint.rotateMix = ((TransformConstraintData)object).rotateMix;
            transformConstraint.translateMix = ((TransformConstraintData)object).translateMix;
            transformConstraint.scaleMix = ((TransformConstraintData)object).scaleMix;
            transformConstraint.shearMix = ((TransformConstraintData)object).shearMix;
        }
        Array<PathConstraint> array4 = this.pathConstraints;
        int n4 = array4.size;
        for (n3 = 0; n3 < n4; ++n3) {
            object = array4.get(n3);
            PathConstraintData pathConstraintData = ((PathConstraint)object).data;
            ((PathConstraint)object).position = pathConstraintData.position;
            ((PathConstraint)object).spacing = pathConstraintData.spacing;
            ((PathConstraint)object).rotateMix = pathConstraintData.rotateMix;
            ((PathConstraint)object).translateMix = pathConstraintData.translateMix;
        }
    }

    public void setSlotsToSetupPose() {
        Array<Slot> array = this.slots;
        System.arraycopy(array.items, 0, this.drawOrder.items, 0, array.size);
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            array.get(i).setToSetupPose();
        }
    }

    public SkeletonData getData() {
        return this.data;
    }

    public Array<Bone> getBones() {
        return this.bones;
    }

    public Array<Updatable> getUpdateCache() {
        return this.updateCache;
    }

    public Bone getRootBone() {
        if (this.bones.size == 0) {
            return null;
        }
        return this.bones.first();
    }

    public Bone findBone(String string) {
        if (string == null) {
            throw new IllegalArgumentException("boneName cannot be null.");
        }
        Array<Bone> array = this.bones;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Bone bone = array.get(i);
            if (!bone.data.name.equals(string)) continue;
            return bone;
        }
        return null;
    }

    public Array<Slot> getSlots() {
        return this.slots;
    }

    public Slot findSlot(String string) {
        if (string == null) {
            throw new IllegalArgumentException("slotName cannot be null.");
        }
        Array<Slot> array = this.slots;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Slot slot = array.get(i);
            if (!slot.data.name.equals(string)) continue;
            return slot;
        }
        return null;
    }

    public Array<Slot> getDrawOrder() {
        return this.drawOrder;
    }

    public void setDrawOrder(Array<Slot> array) {
        if (array == null) {
            throw new IllegalArgumentException("drawOrder cannot be null.");
        }
        this.drawOrder = array;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public void setSkin(String string) {
        Skin skin = this.data.findSkin(string);
        if (skin == null) {
            throw new IllegalArgumentException("Skin not found: " + string);
        }
        this.setSkin(skin);
    }

    public void setSkin(Skin skin) {
        if (skin != null) {
            if (this.skin != null) {
                skin.attachAll(this, this.skin);
            } else {
                Array<Slot> array = this.slots;
                int n = array.size;
                for (int i = 0; i < n; ++i) {
                    Attachment attachment;
                    Slot slot = array.get(i);
                    String string = slot.data.attachmentName;
                    if (string == null || (attachment = skin.getAttachment(i, string)) == null) continue;
                    slot.setAttachment(attachment);
                }
            }
        }
        this.skin = skin;
    }

    public Attachment getAttachment(String string, String string2) {
        SlotData slotData = this.data.findSlot(string);
        if (slotData == null) {
            throw new IllegalArgumentException("Slot not found: " + string);
        }
        return this.getAttachment(slotData.getIndex(), string2);
    }

    public Attachment getAttachment(int n, String string) {
        Attachment attachment;
        if (string == null) {
            throw new IllegalArgumentException("attachmentName cannot be null.");
        }
        if (this.skin != null && (attachment = this.skin.getAttachment(n, string)) != null) {
            return attachment;
        }
        if (this.data.defaultSkin != null) {
            return this.data.defaultSkin.getAttachment(n, string);
        }
        return null;
    }

    public void setAttachment(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("slotName cannot be null.");
        }
        Slot slot = this.findSlot(string);
        if (slot == null) {
            throw new IllegalArgumentException("Slot not found: " + string);
        }
        Attachment attachment = null;
        if (string2 != null && (attachment = this.getAttachment(slot.data.index, string2)) == null) {
            throw new IllegalArgumentException("Attachment not found: " + string2 + ", for slot: " + string);
        }
        slot.setAttachment(attachment);
    }

    public Array<IkConstraint> getIkConstraints() {
        return this.ikConstraints;
    }

    public IkConstraint findIkConstraint(String string) {
        if (string == null) {
            throw new IllegalArgumentException("constraintName cannot be null.");
        }
        Array<IkConstraint> array = this.ikConstraints;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            IkConstraint ikConstraint = array.get(i);
            if (!ikConstraint.data.name.equals(string)) continue;
            return ikConstraint;
        }
        return null;
    }

    public Array<TransformConstraint> getTransformConstraints() {
        return this.transformConstraints;
    }

    public TransformConstraint findTransformConstraint(String string) {
        if (string == null) {
            throw new IllegalArgumentException("constraintName cannot be null.");
        }
        Array<TransformConstraint> array = this.transformConstraints;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            TransformConstraint transformConstraint = array.get(i);
            if (!transformConstraint.data.name.equals(string)) continue;
            return transformConstraint;
        }
        return null;
    }

    public Array<PathConstraint> getPathConstraints() {
        return this.pathConstraints;
    }

    public PathConstraint findPathConstraint(String string) {
        if (string == null) {
            throw new IllegalArgumentException("constraintName cannot be null.");
        }
        Array<PathConstraint> array = this.pathConstraints;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            PathConstraint pathConstraint = array.get(i);
            if (!pathConstraint.data.name.equals(string)) continue;
            return pathConstraint;
        }
        return null;
    }

    public void getBounds(Vector2 vector2, Vector2 vector22, FloatArray floatArray) {
        if (vector2 == null) {
            throw new IllegalArgumentException("offset cannot be null.");
        }
        if (vector22 == null) {
            throw new IllegalArgumentException("size cannot be null.");
        }
        Array<Slot> array = this.drawOrder;
        float f = 2.1474836E9f;
        float f2 = 2.1474836E9f;
        float f3 = -2.1474836E9f;
        float f4 = -2.1474836E9f;
        int n = array.size;
        for (int i = 0; i < n; ++i) {
            Slot slot = array.get(i);
            int n2 = 0;
            float[] fArray = null;
            Attachment attachment = slot.attachment;
            if (attachment instanceof RegionAttachment) {
                n2 = 8;
                fArray = floatArray.setSize(8);
                ((RegionAttachment)attachment).computeWorldVertices(slot.getBone(), fArray, 0, 2);
            } else if (attachment instanceof MeshAttachment) {
                MeshAttachment meshAttachment = (MeshAttachment)attachment;
                n2 = meshAttachment.getWorldVerticesLength();
                fArray = floatArray.setSize(n2);
                meshAttachment.computeWorldVertices(slot, 0, n2, fArray, 0, 2);
            }
            if (fArray == null) continue;
            for (int j = 0; j < n2; j += 2) {
                float f5 = fArray[j];
                float f6 = fArray[j + 1];
                f = Math.min(f, f5);
                f2 = Math.min(f2, f6);
                f3 = Math.max(f3, f5);
                f4 = Math.max(f4, f6);
            }
        }
        vector2.set(f, f2);
        vector22.set(f3 - f, f4 - f2);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color cannot be null.");
        }
        this.color.set(color);
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float f) {
        this.scaleX = f;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float f) {
        this.scaleY = f;
    }

    public void setScale(float f, float f2) {
        this.scaleX = f;
        this.scaleY = f2;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        this.x = f;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        this.y = f;
    }

    public void setPosition(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public float getTime() {
        return this.time;
    }

    public void setTime(float f) {
        this.time = f;
    }

    public void update(float f) {
        this.time += f;
    }

    public String toString() {
        return this.data.name != null ? this.data.name : super.toString();
    }
}

