/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine.attachments;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.esotericsoftware.spine.Bone;
import com.esotericsoftware.spine.attachments.Attachment;

public class PointAttachment
extends Attachment {
    float x;
    float y;
    float rotation;
    final Color color = new Color(0.9451f, 0.9451f, 0.0f, 1.0f);

    public PointAttachment(String string) {
        super(string);
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        this.x = f;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        this.y = f;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float f) {
        this.rotation = f;
    }

    public Color getColor() {
        return this.color;
    }

    public Vector2 computeWorldPosition(Bone bone, Vector2 vector2) {
        vector2.x = this.x * bone.getA() + this.y * bone.getB() + bone.getWorldX();
        vector2.y = this.x * bone.getC() + this.y * bone.getD() + bone.getWorldY();
        return vector2;
    }

    public float computeWorldRotation(Bone bone) {
        float f = MathUtils.cosDeg(this.rotation);
        float f2 = MathUtils.sinDeg(this.rotation);
        float f3 = f * bone.getA() + f2 * bone.getB();
        float f4 = f * bone.getC() + f2 * bone.getD();
        return (float)Math.atan2(f4, f3) * 57.295776f;
    }
}

