/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.SerializationException;
import com.esotericsoftware.spine.Animation;
import com.esotericsoftware.spine.BlendMode;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Event;
import com.esotericsoftware.spine.EventData;
import com.esotericsoftware.spine.IkConstraintData;
import com.esotericsoftware.spine.PathConstraintData;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.Skin;
import com.esotericsoftware.spine.SlotData;
import com.esotericsoftware.spine.TransformConstraintData;
import com.esotericsoftware.spine.attachments.AtlasAttachmentLoader;
import com.esotericsoftware.spine.attachments.Attachment;
import com.esotericsoftware.spine.attachments.AttachmentLoader;
import com.esotericsoftware.spine.attachments.AttachmentType;
import com.esotericsoftware.spine.attachments.BoundingBoxAttachment;
import com.esotericsoftware.spine.attachments.ClippingAttachment;
import com.esotericsoftware.spine.attachments.MeshAttachment;
import com.esotericsoftware.spine.attachments.PathAttachment;
import com.esotericsoftware.spine.attachments.PointAttachment;
import com.esotericsoftware.spine.attachments.RegionAttachment;
import com.esotericsoftware.spine.attachments.VertexAttachment;

public class SkeletonJson {
    private final AttachmentLoader attachmentLoader;
    private float scale = 1.0f;
    private Array<LinkedMesh> linkedMeshes = new Array();

    public SkeletonJson(TextureAtlas textureAtlas) {
        this.attachmentLoader = new AtlasAttachmentLoader(textureAtlas);
    }

    public SkeletonJson(AttachmentLoader attachmentLoader) {
        if (attachmentLoader == null) {
            throw new IllegalArgumentException("attachmentLoader cannot be null.");
        }
        this.attachmentLoader = attachmentLoader;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float f) {
        this.scale = f;
    }

    public SkeletonData readSkeletonData(FileHandle fileHandle) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (fileHandle == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        float f = this.scale;
        SkeletonData skeletonData = new SkeletonData();
        skeletonData.name = fileHandle.nameWithoutExtension();
        JsonValue jsonValue = new JsonReader().parse(fileHandle);
        JsonValue jsonValue2 = jsonValue.get("skeleton");
        if (jsonValue2 != null) {
            skeletonData.hash = jsonValue2.getString("hash", null);
            skeletonData.version = jsonValue2.getString("spine", null);
            skeletonData.width = jsonValue2.getFloat("width", 0.0f);
            skeletonData.height = jsonValue2.getFloat("height", 0.0f);
            skeletonData.fps = jsonValue2.getFloat("fps", 30.0f);
            skeletonData.imagesPath = jsonValue2.getString("images", null);
        }
        JsonValue jsonValue3 = jsonValue.getChild("bones");
        while (jsonValue3 != null) {
            object5 = null;
            object4 = jsonValue3.getString("parent", null);
            if (object4 != null && (object5 = skeletonData.findBone((String)object4)) == null) {
                throw new SerializationException("Parent bone not found: " + (String)object4);
            }
            object3 = new BoneData(skeletonData.bones.size, jsonValue3.getString("name"), (BoneData)object5);
            ((BoneData)object3).length = jsonValue3.getFloat("length", 0.0f) * f;
            ((BoneData)object3).x = jsonValue3.getFloat("x", 0.0f) * f;
            ((BoneData)object3).y = jsonValue3.getFloat("y", 0.0f) * f;
            ((BoneData)object3).rotation = jsonValue3.getFloat("rotation", 0.0f);
            ((BoneData)object3).scaleX = jsonValue3.getFloat("scaleX", 1.0f);
            ((BoneData)object3).scaleY = jsonValue3.getFloat("scaleY", 1.0f);
            ((BoneData)object3).shearX = jsonValue3.getFloat("shearX", 0.0f);
            ((BoneData)object3).shearY = jsonValue3.getFloat("shearY", 0.0f);
            ((BoneData)object3).transformMode = BoneData.TransformMode.valueOf(jsonValue3.getString("transform", BoneData.TransformMode.normal.name()));
            object2 = jsonValue3.getString("color", null);
            if (object2 != null) {
                ((BoneData)object3).getColor().set(Color.valueOf((String)object2));
            }
            skeletonData.bones.add((BoneData)object3);
            jsonValue3 = jsonValue3.next;
        }
        jsonValue3 = jsonValue.getChild("slots");
        while (jsonValue3 != null) {
            String string;
            object5 = jsonValue3.getString("name");
            object4 = jsonValue3.getString("bone");
            object3 = skeletonData.findBone((String)object4);
            if (object3 == null) {
                throw new SerializationException("Slot bone not found: " + (String)object4);
            }
            object2 = new SlotData(skeletonData.slots.size, (String)object5, (BoneData)object3);
            object = jsonValue3.getString("color", null);
            if (object != null) {
                ((SlotData)object2).getColor().set(Color.valueOf((String)object));
            }
            if ((string = jsonValue3.getString("dark", null)) != null) {
                ((SlotData)object2).setDarkColor(Color.valueOf(string));
            }
            ((SlotData)object2).attachmentName = jsonValue3.getString("attachment", null);
            ((SlotData)object2).blendMode = BlendMode.valueOf(jsonValue3.getString("blend", BlendMode.normal.name()));
            skeletonData.slots.add((SlotData)object2);
            jsonValue3 = jsonValue3.next;
        }
        jsonValue3 = jsonValue.getChild("ik");
        while (jsonValue3 != null) {
            object5 = new IkConstraintData(jsonValue3.getString("name"));
            ((IkConstraintData)object5).order = jsonValue3.getInt("order", 0);
            object4 = jsonValue3.getChild("bones");
            while (object4 != null) {
                object3 = ((JsonValue)object4).asString();
                object2 = skeletonData.findBone((String)object3);
                if (object2 == null) {
                    throw new SerializationException("IK bone not found: " + (String)object3);
                }
                ((IkConstraintData)object5).bones.add((BoneData)object2);
                object4 = ((JsonValue)object4).next;
            }
            object4 = jsonValue3.getString("target");
            ((IkConstraintData)object5).target = skeletonData.findBone((String)object4);
            if (((IkConstraintData)object5).target == null) {
                throw new SerializationException("IK target bone not found: " + (String)object4);
            }
            ((IkConstraintData)object5).bendDirection = jsonValue3.getBoolean("bendPositive", true) ? 1 : -1;
            ((IkConstraintData)object5).mix = jsonValue3.getFloat("mix", 1.0f);
            skeletonData.ikConstraints.add((IkConstraintData)object5);
            jsonValue3 = jsonValue3.next;
        }
        jsonValue3 = jsonValue.getChild("transform");
        while (jsonValue3 != null) {
            object5 = new TransformConstraintData(jsonValue3.getString("name"));
            ((TransformConstraintData)object5).order = jsonValue3.getInt("order", 0);
            object4 = jsonValue3.getChild("bones");
            while (object4 != null) {
                object3 = ((JsonValue)object4).asString();
                object2 = skeletonData.findBone((String)object3);
                if (object2 == null) {
                    throw new SerializationException("Transform constraint bone not found: " + (String)object3);
                }
                ((TransformConstraintData)object5).bones.add((BoneData)object2);
                object4 = ((JsonValue)object4).next;
            }
            object4 = jsonValue3.getString("target");
            ((TransformConstraintData)object5).target = skeletonData.findBone((String)object4);
            if (((TransformConstraintData)object5).target == null) {
                throw new SerializationException("Transform constraint target bone not found: " + (String)object4);
            }
            ((TransformConstraintData)object5).local = jsonValue3.getBoolean("local", false);
            ((TransformConstraintData)object5).relative = jsonValue3.getBoolean("relative", false);
            ((TransformConstraintData)object5).offsetRotation = jsonValue3.getFloat("rotation", 0.0f);
            ((TransformConstraintData)object5).offsetX = jsonValue3.getFloat("x", 0.0f) * f;
            ((TransformConstraintData)object5).offsetY = jsonValue3.getFloat("y", 0.0f) * f;
            ((TransformConstraintData)object5).offsetScaleX = jsonValue3.getFloat("scaleX", 0.0f);
            ((TransformConstraintData)object5).offsetScaleY = jsonValue3.getFloat("scaleY", 0.0f);
            ((TransformConstraintData)object5).offsetShearY = jsonValue3.getFloat("shearY", 0.0f);
            ((TransformConstraintData)object5).rotateMix = jsonValue3.getFloat("rotateMix", 1.0f);
            ((TransformConstraintData)object5).translateMix = jsonValue3.getFloat("translateMix", 1.0f);
            ((TransformConstraintData)object5).scaleMix = jsonValue3.getFloat("scaleMix", 1.0f);
            ((TransformConstraintData)object5).shearMix = jsonValue3.getFloat("shearMix", 1.0f);
            skeletonData.transformConstraints.add((TransformConstraintData)object5);
            jsonValue3 = jsonValue3.next;
        }
        jsonValue3 = jsonValue.getChild("path");
        while (jsonValue3 != null) {
            object5 = new PathConstraintData(jsonValue3.getString("name"));
            ((PathConstraintData)object5).order = jsonValue3.getInt("order", 0);
            object4 = jsonValue3.getChild("bones");
            while (object4 != null) {
                object3 = ((JsonValue)object4).asString();
                object2 = skeletonData.findBone((String)object3);
                if (object2 == null) {
                    throw new SerializationException("Path bone not found: " + (String)object3);
                }
                ((PathConstraintData)object5).bones.add((BoneData)object2);
                object4 = ((JsonValue)object4).next;
            }
            object4 = jsonValue3.getString("target");
            ((PathConstraintData)object5).target = skeletonData.findSlot((String)object4);
            if (((PathConstraintData)object5).target == null) {
                throw new SerializationException("Path target slot not found: " + (String)object4);
            }
            ((PathConstraintData)object5).positionMode = PathConstraintData.PositionMode.valueOf(jsonValue3.getString("positionMode", "percent"));
            ((PathConstraintData)object5).spacingMode = PathConstraintData.SpacingMode.valueOf(jsonValue3.getString("spacingMode", "length"));
            ((PathConstraintData)object5).rotateMode = PathConstraintData.RotateMode.valueOf(jsonValue3.getString("rotateMode", "tangent"));
            ((PathConstraintData)object5).offsetRotation = jsonValue3.getFloat("rotation", 0.0f);
            ((PathConstraintData)object5).position = jsonValue3.getFloat("position", 0.0f);
            if (((PathConstraintData)object5).positionMode == PathConstraintData.PositionMode.fixed) {
                ((PathConstraintData)object5).position *= f;
            }
            ((PathConstraintData)object5).spacing = jsonValue3.getFloat("spacing", 0.0f);
            if (((PathConstraintData)object5).spacingMode == PathConstraintData.SpacingMode.length || ((PathConstraintData)object5).spacingMode == PathConstraintData.SpacingMode.fixed) {
                ((PathConstraintData)object5).spacing *= f;
            }
            ((PathConstraintData)object5).rotateMix = jsonValue3.getFloat("rotateMix", 1.0f);
            ((PathConstraintData)object5).translateMix = jsonValue3.getFloat("translateMix", 1.0f);
            skeletonData.pathConstraints.add((PathConstraintData)object5);
            jsonValue3 = jsonValue3.next;
        }
        jsonValue3 = jsonValue.getChild("skins");
        while (jsonValue3 != null) {
            object5 = new Skin(jsonValue3.name);
            object4 = jsonValue3.child;
            while (object4 != null) {
                object3 = skeletonData.findSlot(((JsonValue)object4).name);
                if (object3 == null) {
                    throw new SerializationException("Slot not found: " + ((JsonValue)object4).name);
                }
                object2 = ((JsonValue)object4).child;
                while (object2 != null) {
                    try {
                        object = this.readAttachment((JsonValue)object2, (Skin)object5, ((SlotData)object3).index, ((JsonValue)object2).name, skeletonData);
                        if (object != null) {
                            ((Skin)object5).addAttachment(((SlotData)object3).index, ((JsonValue)object2).name, (Attachment)object);
                        }
                    }
                    catch (Exception exception) {
                        throw new SerializationException("Error reading attachment: " + ((JsonValue)object2).name + ", skin: " + (Skin)object5, exception);
                    }
                    object2 = ((JsonValue)object2).next;
                }
                object4 = ((JsonValue)object4).next;
            }
            skeletonData.skins.add((Skin)object5);
            if (((Skin)object5).name.equals("default")) {
                skeletonData.defaultSkin = object5;
            }
            jsonValue3 = jsonValue3.next;
        }
        int n = this.linkedMeshes.size;
        for (int i = 0; i < n; ++i) {
            object4 = this.linkedMeshes.get(i);
            Object object6 = object3 = ((LinkedMesh)object4).skin == null ? skeletonData.getDefaultSkin() : skeletonData.findSkin(((LinkedMesh)object4).skin);
            if (object3 == null) {
                throw new SerializationException("Skin not found: " + ((LinkedMesh)object4).skin);
            }
            object2 = ((Skin)object3).getAttachment(((LinkedMesh)object4).slotIndex, ((LinkedMesh)object4).parent);
            if (object2 == null) {
                throw new SerializationException("Parent mesh not found: " + ((LinkedMesh)object4).parent);
            }
            ((LinkedMesh)object4).mesh.setParentMesh((MeshAttachment)object2);
            ((LinkedMesh)object4).mesh.updateUVs();
        }
        this.linkedMeshes.clear();
        JsonValue jsonValue4 = jsonValue.getChild("events");
        while (jsonValue4 != null) {
            EventData eventData = new EventData(jsonValue4.name);
            eventData.intValue = jsonValue4.getInt("int", 0);
            eventData.floatValue = jsonValue4.getFloat("float", 0.0f);
            eventData.stringValue = jsonValue4.getString("string", "");
            skeletonData.events.add(eventData);
            jsonValue4 = jsonValue4.next;
        }
        jsonValue4 = jsonValue.getChild("animations");
        while (jsonValue4 != null) {
            try {
                this.readAnimation(jsonValue4, jsonValue4.name, skeletonData);
            }
            catch (Exception exception) {
                throw new SerializationException("Error reading animation: " + jsonValue4.name, exception);
            }
            jsonValue4 = jsonValue4.next;
        }
        skeletonData.bones.shrink();
        skeletonData.slots.shrink();
        skeletonData.skins.shrink();
        skeletonData.events.shrink();
        skeletonData.animations.shrink();
        skeletonData.ikConstraints.shrink();
        return skeletonData;
    }

    private Attachment readAttachment(JsonValue jsonValue, Skin skin, int n, String string, SkeletonData skeletonData) {
        float f = this.scale;
        string = jsonValue.getString("name", string);
        String string2 = jsonValue.getString("type", AttachmentType.region.name());
        switch (AttachmentType.valueOf(string2)) {
            case region: {
                String string3 = jsonValue.getString("path", string);
                RegionAttachment regionAttachment = this.attachmentLoader.newRegionAttachment(skin, string, string3);
                if (regionAttachment == null) {
                    return null;
                }
                regionAttachment.setPath(string3);
                regionAttachment.setX(jsonValue.getFloat("x", 0.0f) * f);
                regionAttachment.setY(jsonValue.getFloat("y", 0.0f) * f);
                regionAttachment.setScaleX(jsonValue.getFloat("scaleX", 1.0f));
                regionAttachment.setScaleY(jsonValue.getFloat("scaleY", 1.0f));
                regionAttachment.setRotation(jsonValue.getFloat("rotation", 0.0f));
                regionAttachment.setWidth(jsonValue.getFloat("width") * f);
                regionAttachment.setHeight(jsonValue.getFloat("height") * f);
                String string4 = jsonValue.getString("color", null);
                if (string4 != null) {
                    regionAttachment.getColor().set(Color.valueOf(string4));
                }
                regionAttachment.updateOffset();
                return regionAttachment;
            }
            case boundingbox: {
                BoundingBoxAttachment boundingBoxAttachment = this.attachmentLoader.newBoundingBoxAttachment(skin, string);
                if (boundingBoxAttachment == null) {
                    return null;
                }
                this.readVertices(jsonValue, boundingBoxAttachment, jsonValue.getInt("vertexCount") << 1);
                String string5 = jsonValue.getString("color", null);
                if (string5 != null) {
                    boundingBoxAttachment.getColor().set(Color.valueOf(string5));
                }
                return boundingBoxAttachment;
            }
            case mesh: 
            case linkedmesh: {
                String string6 = jsonValue.getString("path", string);
                MeshAttachment meshAttachment = this.attachmentLoader.newMeshAttachment(skin, string, string6);
                if (meshAttachment == null) {
                    return null;
                }
                meshAttachment.setPath(string6);
                String string7 = jsonValue.getString("color", null);
                if (string7 != null) {
                    meshAttachment.getColor().set(Color.valueOf(string7));
                }
                meshAttachment.setWidth(jsonValue.getFloat("width", 0.0f) * f);
                meshAttachment.setHeight(jsonValue.getFloat("height", 0.0f) * f);
                String string8 = jsonValue.getString("parent", null);
                if (string8 != null) {
                    meshAttachment.setInheritDeform(jsonValue.getBoolean("deform", true));
                    this.linkedMeshes.add(new LinkedMesh(meshAttachment, jsonValue.getString("skin", null), n, string8));
                    return meshAttachment;
                }
                float[] fArray = jsonValue.require("uvs").asFloatArray();
                this.readVertices(jsonValue, meshAttachment, fArray.length);
                meshAttachment.setTriangles(jsonValue.require("triangles").asShortArray());
                meshAttachment.setRegionUVs(fArray);
                meshAttachment.updateUVs();
                if (jsonValue.has("hull")) {
                    meshAttachment.setHullLength(jsonValue.require("hull").asInt() * 2);
                }
                if (jsonValue.has("edges")) {
                    meshAttachment.setEdges(jsonValue.require("edges").asShortArray());
                }
                return meshAttachment;
            }
            case path: {
                PathAttachment pathAttachment = this.attachmentLoader.newPathAttachment(skin, string);
                if (pathAttachment == null) {
                    return null;
                }
                pathAttachment.setClosed(jsonValue.getBoolean("closed", false));
                pathAttachment.setConstantSpeed(jsonValue.getBoolean("constantSpeed", true));
                int n2 = jsonValue.getInt("vertexCount");
                this.readVertices(jsonValue, pathAttachment, n2 << 1);
                float[] fArray = new float[n2 / 3];
                int n3 = 0;
                Object object = jsonValue.require((String)"lengths").child;
                while (object != null) {
                    fArray[n3++] = ((JsonValue)object).asFloat() * f;
                    object = ((JsonValue)object).next;
                }
                pathAttachment.setLengths(fArray);
                object = jsonValue.getString("color", null);
                if (object != null) {
                    pathAttachment.getColor().set(Color.valueOf((String)object));
                }
                return pathAttachment;
            }
            case point: {
                PointAttachment pointAttachment = this.attachmentLoader.newPointAttachment(skin, string);
                if (pointAttachment == null) {
                    return null;
                }
                pointAttachment.setX(jsonValue.getFloat("x", 0.0f) * f);
                pointAttachment.setY(jsonValue.getFloat("y", 0.0f) * f);
                pointAttachment.setRotation(jsonValue.getFloat("rotation", 0.0f));
                String string9 = jsonValue.getString("color", null);
                if (string9 != null) {
                    pointAttachment.getColor().set(Color.valueOf(string9));
                }
                return pointAttachment;
            }
            case clipping: {
                Object object;
                ClippingAttachment clippingAttachment = this.attachmentLoader.newClippingAttachment(skin, string);
                if (clippingAttachment == null) {
                    return null;
                }
                String string10 = jsonValue.getString("end", null);
                if (string10 != null) {
                    object = skeletonData.findSlot(string10);
                    if (object == null) {
                        throw new SerializationException("Clipping end slot not found: " + string10);
                    }
                    clippingAttachment.setEndSlot((SlotData)object);
                }
                this.readVertices(jsonValue, clippingAttachment, jsonValue.getInt("vertexCount") << 1);
                object = jsonValue.getString("color", null);
                if (object != null) {
                    clippingAttachment.getColor().set(Color.valueOf((String)object));
                }
                return clippingAttachment;
            }
        }
        return null;
    }

    private void readVertices(JsonValue jsonValue, VertexAttachment vertexAttachment, int n) {
        vertexAttachment.setWorldVerticesLength(n);
        float[] fArray = jsonValue.require("vertices").asFloatArray();
        if (n == fArray.length) {
            if (this.scale != 1.0f) {
                int n2 = 0;
                int n3 = fArray.length;
                while (n2 < n3) {
                    int n4 = n2++;
                    fArray[n4] = fArray[n4] * this.scale;
                }
            }
            vertexAttachment.setVertices(fArray);
            return;
        }
        FloatArray floatArray = new FloatArray(n * 3 * 3);
        IntArray intArray = new IntArray(n * 3);
        int n5 = 0;
        int n6 = fArray.length;
        while (n5 < n6) {
            int n7 = (int)fArray[n5++];
            intArray.add(n7);
            int n8 = n5 + n7 * 4;
            while (n5 < n8) {
                intArray.add((int)fArray[n5]);
                floatArray.add(fArray[n5 + 1] * this.scale);
                floatArray.add(fArray[n5 + 2] * this.scale);
                floatArray.add(fArray[n5 + 3]);
                n5 += 4;
            }
        }
        vertexAttachment.setBones(intArray.toArray());
        vertexAttachment.setVertices(floatArray.toArray());
    }

    private void readAnimation(JsonValue jsonValue, String string, SkeletonData skeletonData) {
        Object object;
        int n;
        Object object2;
        Object object3;
        String string2;
        Object object4;
        Object object5;
        float f = this.scale;
        Array<Animation.Timeline> array = new Array<Animation.Timeline>();
        float f2 = 0.0f;
        JsonValue jsonValue2 = jsonValue.getChild("slots");
        while (jsonValue2 != null) {
            object5 = skeletonData.findSlot(jsonValue2.name);
            if (object5 == null) {
                throw new SerializationException("Slot not found: " + jsonValue2.name);
            }
            object4 = jsonValue2.child;
            while (object4 != null) {
                string2 = ((JsonValue)object4).name;
                if (string2.equals("attachment")) {
                    object3 = new Animation.AttachmentTimeline(((JsonValue)object4).size);
                    ((Animation.AttachmentTimeline)object3).slotIndex = ((SlotData)object5).index;
                    var12_23 = 0;
                    var13_31 = ((JsonValue)object4).child;
                    while (var13_31 != null) {
                        ((Animation.AttachmentTimeline)object3).setFrame(var12_23++, var13_31.getFloat("time"), var13_31.getString("name"));
                        var13_31 = var13_31.next;
                    }
                    array.add((Animation.Timeline)object3);
                    f2 = Math.max(f2, ((Animation.AttachmentTimeline)object3).getFrames()[((Animation.AttachmentTimeline)object3).getFrameCount() - 1]);
                } else if (string2.equals("color")) {
                    object3 = new Animation.ColorTimeline(((JsonValue)object4).size);
                    ((Animation.ColorTimeline)object3).slotIndex = ((SlotData)object5).index;
                    var12_23 = 0;
                    var13_31 = ((JsonValue)object4).child;
                    while (var13_31 != null) {
                        object2 = Color.valueOf(var13_31.getString("color"));
                        ((Animation.ColorTimeline)object3).setFrame(var12_23, var13_31.getFloat("time"), ((Color)object2).r, ((Color)object2).g, ((Color)object2).b, ((Color)object2).a);
                        this.readCurve(var13_31, (Animation.CurveTimeline)object3, var12_23);
                        ++var12_23;
                        var13_31 = var13_31.next;
                    }
                    array.add((Animation.Timeline)object3);
                    f2 = Math.max(f2, ((Animation.ColorTimeline)object3).getFrames()[(((Animation.CurveTimeline)object3).getFrameCount() - 1) * 5]);
                } else if (string2.equals("twoColor")) {
                    object3 = new Animation.TwoColorTimeline(((JsonValue)object4).size);
                    ((Animation.TwoColorTimeline)object3).slotIndex = ((SlotData)object5).index;
                    var12_23 = 0;
                    var13_31 = ((JsonValue)object4).child;
                    while (var13_31 != null) {
                        object2 = Color.valueOf(var13_31.getString("light"));
                        Color color = Color.valueOf(var13_31.getString("dark"));
                        ((Animation.TwoColorTimeline)object3).setFrame(var12_23, var13_31.getFloat("time"), ((Color)object2).r, ((Color)object2).g, ((Color)object2).b, ((Color)object2).a, color.r, color.g, color.b);
                        this.readCurve(var13_31, (Animation.CurveTimeline)object3, var12_23);
                        ++var12_23;
                        var13_31 = var13_31.next;
                    }
                    array.add((Animation.Timeline)object3);
                    f2 = Math.max(f2, ((Animation.TwoColorTimeline)object3).getFrames()[(((Animation.CurveTimeline)object3).getFrameCount() - 1) * 8]);
                } else {
                    throw new RuntimeException("Invalid timeline type for a slot: " + string2 + " (" + jsonValue2.name + ")");
                }
                object4 = ((JsonValue)object4).next;
            }
            jsonValue2 = jsonValue2.next;
        }
        jsonValue2 = jsonValue.getChild("bones");
        while (jsonValue2 != null) {
            object5 = skeletonData.findBone(jsonValue2.name);
            if (object5 == null) {
                throw new SerializationException("Bone not found: " + jsonValue2.name);
            }
            object4 = jsonValue2.child;
            while (object4 != null) {
                string2 = ((JsonValue)object4).name;
                if (string2.equals("rotate")) {
                    object3 = new Animation.RotateTimeline(((JsonValue)object4).size);
                    ((Animation.RotateTimeline)object3).boneIndex = ((BoneData)object5).index;
                    int n2 = 0;
                    JsonValue jsonValue3 = ((JsonValue)object4).child;
                    while (jsonValue3 != null) {
                        ((Animation.RotateTimeline)object3).setFrame(n2, jsonValue3.getFloat("time"), jsonValue3.getFloat("angle"));
                        this.readCurve(jsonValue3, (Animation.CurveTimeline)object3, n2);
                        ++n2;
                        jsonValue3 = jsonValue3.next;
                    }
                    array.add((Animation.Timeline)object3);
                    f2 = Math.max(f2, ((Animation.RotateTimeline)object3).getFrames()[(((Animation.CurveTimeline)object3).getFrameCount() - 1) * 2]);
                } else if (string2.equals("translate") || string2.equals("scale") || string2.equals("shear")) {
                    float f3 = 1.0f;
                    if (string2.equals("scale")) {
                        object3 = new Animation.ScaleTimeline(((JsonValue)object4).size);
                    } else if (string2.equals("shear")) {
                        object3 = new Animation.ShearTimeline(((JsonValue)object4).size);
                    } else {
                        object3 = new Animation.TranslateTimeline(((JsonValue)object4).size);
                        f3 = f;
                    }
                    ((Animation.TranslateTimeline)object3).boneIndex = ((BoneData)object5).index;
                    int n3 = 0;
                    object2 = ((JsonValue)object4).child;
                    while (object2 != null) {
                        float f4 = ((JsonValue)object2).getFloat("x", 0.0f);
                        float f5 = ((JsonValue)object2).getFloat("y", 0.0f);
                        ((Animation.TranslateTimeline)object3).setFrame(n3, ((JsonValue)object2).getFloat("time"), f4 * f3, f5 * f3);
                        this.readCurve((JsonValue)object2, (Animation.CurveTimeline)object3, n3);
                        ++n3;
                        object2 = ((JsonValue)object2).next;
                    }
                    array.add((Animation.Timeline)object3);
                    f2 = Math.max(f2, ((Animation.TranslateTimeline)object3).getFrames()[(((Animation.CurveTimeline)object3).getFrameCount() - 1) * 3]);
                } else {
                    throw new RuntimeException("Invalid timeline type for a bone: " + string2 + " (" + jsonValue2.name + ")");
                }
                object4 = ((JsonValue)object4).next;
            }
            jsonValue2 = jsonValue2.next;
        }
        jsonValue2 = jsonValue.getChild("ik");
        while (jsonValue2 != null) {
            object5 = skeletonData.findIkConstraint(jsonValue2.name);
            object4 = new Animation.IkConstraintTimeline(jsonValue2.size);
            ((Animation.IkConstraintTimeline)object4).ikConstraintIndex = skeletonData.getIkConstraints().indexOf((IkConstraintData)object5, true);
            int n4 = 0;
            object3 = jsonValue2.child;
            while (object3 != null) {
                ((Animation.IkConstraintTimeline)object4).setFrame(n4, ((JsonValue)object3).getFloat("time"), ((JsonValue)object3).getFloat("mix", 1.0f), ((JsonValue)object3).getBoolean("bendPositive", true) ? 1 : -1);
                this.readCurve((JsonValue)object3, (Animation.CurveTimeline)object4, n4);
                ++n4;
                object3 = ((JsonValue)object3).next;
            }
            array.add((Animation.Timeline)object4);
            f2 = Math.max(f2, ((Animation.IkConstraintTimeline)object4).getFrames()[(((Animation.CurveTimeline)object4).getFrameCount() - 1) * 3]);
            jsonValue2 = jsonValue2.next;
        }
        jsonValue2 = jsonValue.getChild("transform");
        while (jsonValue2 != null) {
            object5 = skeletonData.findTransformConstraint(jsonValue2.name);
            object4 = new Animation.TransformConstraintTimeline(jsonValue2.size);
            ((Animation.TransformConstraintTimeline)object4).transformConstraintIndex = skeletonData.getTransformConstraints().indexOf((TransformConstraintData)object5, true);
            int n5 = 0;
            object3 = jsonValue2.child;
            while (object3 != null) {
                ((Animation.TransformConstraintTimeline)object4).setFrame(n5, ((JsonValue)object3).getFloat("time"), ((JsonValue)object3).getFloat("rotateMix", 1.0f), ((JsonValue)object3).getFloat("translateMix", 1.0f), ((JsonValue)object3).getFloat("scaleMix", 1.0f), ((JsonValue)object3).getFloat("shearMix", 1.0f));
                this.readCurve((JsonValue)object3, (Animation.CurveTimeline)object4, n5);
                ++n5;
                object3 = ((JsonValue)object3).next;
            }
            array.add((Animation.Timeline)object4);
            f2 = Math.max(f2, ((Animation.TransformConstraintTimeline)object4).getFrames()[(((Animation.CurveTimeline)object4).getFrameCount() - 1) * 5]);
            jsonValue2 = jsonValue2.next;
        }
        jsonValue2 = jsonValue.getChild("paths");
        while (jsonValue2 != null) {
            object5 = skeletonData.findPathConstraint(jsonValue2.name);
            if (object5 == null) {
                throw new SerializationException("Path constraint not found: " + jsonValue2.name);
            }
            int n6 = skeletonData.pathConstraints.indexOf((PathConstraintData)object5, true);
            JsonValue jsonValue4 = jsonValue2.child;
            while (jsonValue4 != null) {
                object3 = jsonValue4.name;
                if (((String)object3).equals("position") || ((String)object3).equals("spacing")) {
                    float f6 = 1.0f;
                    if (((String)object3).equals("spacing")) {
                        var12_27 = new Animation.PathConstraintSpacingTimeline(jsonValue4.size);
                        if (((PathConstraintData)object5).spacingMode == PathConstraintData.SpacingMode.length || ((PathConstraintData)object5).spacingMode == PathConstraintData.SpacingMode.fixed) {
                            f6 = f;
                        }
                    } else {
                        var12_27 = new Animation.PathConstraintPositionTimeline(jsonValue4.size);
                        if (((PathConstraintData)object5).positionMode == PathConstraintData.PositionMode.fixed) {
                            f6 = f;
                        }
                    }
                    ((Animation.PathConstraintPositionTimeline)var12_27).pathConstraintIndex = n6;
                    int n7 = 0;
                    JsonValue jsonValue5 = jsonValue4.child;
                    while (jsonValue5 != null) {
                        ((Animation.PathConstraintPositionTimeline)var12_27).setFrame(n7, jsonValue5.getFloat("time"), jsonValue5.getFloat((String)object3, 0.0f) * f6);
                        this.readCurve(jsonValue5, var12_27, n7);
                        ++n7;
                        jsonValue5 = jsonValue5.next;
                    }
                    array.add(var12_27);
                    f2 = Math.max(f2, ((Animation.PathConstraintPositionTimeline)var12_27).getFrames()[(var12_27.getFrameCount() - 1) * 2]);
                } else if (((String)object3).equals("mix")) {
                    var12_27 = new Animation.PathConstraintMixTimeline(jsonValue4.size);
                    ((Animation.PathConstraintMixTimeline)var12_27).pathConstraintIndex = n6;
                    int n8 = 0;
                    JsonValue jsonValue6 = jsonValue4.child;
                    while (jsonValue6 != null) {
                        ((Animation.PathConstraintMixTimeline)var12_27).setFrame(n8, jsonValue6.getFloat("time"), jsonValue6.getFloat("rotateMix", 1.0f), jsonValue6.getFloat("translateMix", 1.0f));
                        this.readCurve(jsonValue6, var12_27, n8);
                        ++n8;
                        jsonValue6 = jsonValue6.next;
                    }
                    array.add(var12_27);
                    f2 = Math.max(f2, ((Animation.PathConstraintMixTimeline)var12_27).getFrames()[(var12_27.getFrameCount() - 1) * 3]);
                }
                jsonValue4 = jsonValue4.next;
            }
            jsonValue2 = jsonValue2.next;
        }
        jsonValue2 = jsonValue.getChild("deform");
        while (jsonValue2 != null) {
            object5 = skeletonData.findSkin(jsonValue2.name);
            if (object5 == null) {
                throw new SerializationException("Skin not found: " + jsonValue2.name);
            }
            JsonValue jsonValue7 = jsonValue2.child;
            while (jsonValue7 != null) {
                SlotData slotData = skeletonData.findSlot(jsonValue7.name);
                if (slotData == null) {
                    throw new SerializationException("Slot not found: " + jsonValue7.name);
                }
                object3 = jsonValue7.child;
                while (object3 != null) {
                    VertexAttachment vertexAttachment = (VertexAttachment)((Skin)object5).getAttachment(slotData.index, ((JsonValue)object3).name);
                    if (vertexAttachment == null) {
                        throw new SerializationException("Deform attachment not found: " + ((JsonValue)object3).name);
                    }
                    boolean bl = vertexAttachment.getBones() != null;
                    float[] fArray = vertexAttachment.getVertices();
                    int n9 = bl ? fArray.length / 3 * 2 : fArray.length;
                    Animation.DeformTimeline deformTimeline = new Animation.DeformTimeline(((JsonValue)object3).size);
                    deformTimeline.slotIndex = slotData.index;
                    deformTimeline.attachment = vertexAttachment;
                    n = 0;
                    object = ((JsonValue)object3).child;
                    while (object != null) {
                        float[] fArray2;
                        JsonValue jsonValue8 = ((JsonValue)object).get("vertices");
                        if (jsonValue8 == null) {
                            fArray2 = bl ? new float[n9] : fArray;
                        } else {
                            int n10;
                            fArray2 = new float[n9];
                            int n11 = ((JsonValue)object).getInt("offset", 0);
                            System.arraycopy(jsonValue8.asFloatArray(), 0, fArray2, n11, jsonValue8.size);
                            if (f != 1.0f) {
                                n10 = n11;
                                int n12 = n10 + jsonValue8.size;
                                while (n10 < n12) {
                                    int n13 = n10++;
                                    fArray2[n13] = fArray2[n13] * f;
                                }
                            }
                            if (!bl) {
                                for (n10 = 0; n10 < n9; ++n10) {
                                    int n14 = n10;
                                    fArray2[n14] = fArray2[n14] + fArray[n10];
                                }
                            }
                        }
                        deformTimeline.setFrame(n, ((JsonValue)object).getFloat("time"), fArray2);
                        this.readCurve((JsonValue)object, deformTimeline, n);
                        ++n;
                        object = ((JsonValue)object).next;
                    }
                    array.add(deformTimeline);
                    f2 = Math.max(f2, deformTimeline.getFrames()[deformTimeline.getFrameCount() - 1]);
                    object3 = ((JsonValue)object3).next;
                }
                jsonValue7 = jsonValue7.next;
            }
            jsonValue2 = jsonValue2.next;
        }
        jsonValue2 = jsonValue.get("drawOrder");
        if (jsonValue2 == null) {
            jsonValue2 = jsonValue.get("draworder");
        }
        if (jsonValue2 != null) {
            object5 = new Animation.DrawOrderTimeline(jsonValue2.size);
            int n15 = skeletonData.slots.size;
            int n16 = 0;
            object3 = jsonValue2.child;
            while (object3 != null) {
                int[] nArray = null;
                JsonValue jsonValue9 = ((JsonValue)object3).get("offsets");
                if (jsonValue9 != null) {
                    nArray = new int[n15];
                    for (int i = n15 - 1; i >= 0; --i) {
                        nArray[i] = -1;
                    }
                    int[] nArray2 = new int[n15 - jsonValue9.size];
                    int n17 = 0;
                    int n18 = 0;
                    JsonValue jsonValue10 = jsonValue9.child;
                    while (jsonValue10 != null) {
                        object = skeletonData.findSlot(jsonValue10.getString("slot"));
                        if (object == null) {
                            throw new SerializationException("Slot not found: " + jsonValue10.getString("slot"));
                        }
                        while (n17 != ((SlotData)object).index) {
                            nArray2[n18++] = n17++;
                        }
                        nArray[n17 + jsonValue10.getInt((String)"offset")] = n17++;
                        jsonValue10 = jsonValue10.next;
                    }
                    while (n17 < n15) {
                        nArray2[n18++] = n17++;
                    }
                    for (n = n15 - 1; n >= 0; --n) {
                        if (nArray[n] != -1) continue;
                        nArray[n] = nArray2[--n18];
                    }
                }
                ((Animation.DrawOrderTimeline)object5).setFrame(n16++, ((JsonValue)object3).getFloat("time"), nArray);
                object3 = ((JsonValue)object3).next;
            }
            array.add((Animation.Timeline)object5);
            f2 = Math.max(f2, ((Animation.DrawOrderTimeline)object5).getFrames()[((Animation.DrawOrderTimeline)object5).getFrameCount() - 1]);
        }
        if ((object5 = jsonValue.get("events")) != null) {
            Animation.EventTimeline eventTimeline = new Animation.EventTimeline(((JsonValue)object5).size);
            int n19 = 0;
            object3 = ((JsonValue)object5).child;
            while (object3 != null) {
                EventData eventData = skeletonData.findEvent(((JsonValue)object3).getString("name"));
                if (eventData == null) {
                    throw new SerializationException("Event not found: " + ((JsonValue)object3).getString("name"));
                }
                Event event = new Event(((JsonValue)object3).getFloat("time"), eventData);
                event.intValue = ((JsonValue)object3).getInt("int", eventData.getInt());
                event.floatValue = ((JsonValue)object3).getFloat("float", eventData.getFloat());
                event.stringValue = ((JsonValue)object3).getString("string", eventData.getString());
                eventTimeline.setFrame(n19++, event);
                object3 = ((JsonValue)object3).next;
            }
            array.add(eventTimeline);
            f2 = Math.max(f2, eventTimeline.getFrames()[eventTimeline.getFrameCount() - 1]);
        }
        array.shrink();
        skeletonData.animations.add(new Animation(string, array, f2));
    }

    void readCurve(JsonValue jsonValue, Animation.CurveTimeline curveTimeline, int n) {
        JsonValue jsonValue2 = jsonValue.get("curve");
        if (jsonValue2 == null) {
            return;
        }
        if (jsonValue2.isString() && jsonValue2.asString().equals("stepped")) {
            curveTimeline.setStepped(n);
        } else if (jsonValue2.isArray()) {
            curveTimeline.setCurve(n, jsonValue2.getFloat(0), jsonValue2.getFloat(1), jsonValue2.getFloat(2), jsonValue2.getFloat(3));
        }
    }

    static class LinkedMesh {
        String parent;
        String skin;
        int slotIndex;
        MeshAttachment mesh;

        public LinkedMesh(MeshAttachment meshAttachment, String string, int n, String string2) {
            this.mesh = meshAttachment;
            this.skin = string;
            this.slotIndex = n;
            this.parent = string2;
        }
    }
}

