/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.spine;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.spine.BoneData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.Updatable;
import com.esotericsoftware.spine.utils.TrigUtils;

public class Bone
implements Updatable {
    final BoneData data;
    final Skeleton skeleton;
    final Bone parent;
    final Array<Bone> children = new Array();
    float x;
    float y;
    float rotation;
    float scaleX;
    float scaleY;
    float shearX;
    float shearY;
    float ax;
    float ay;
    float arotation;
    float ascaleX;
    float ascaleY;
    float ashearX;
    float ashearY;
    boolean appliedValid;
    float a;
    float b;
    float worldX;
    float c;
    float d;
    float worldY;
    boolean sorted;

    public Bone(BoneData boneData, Skeleton skeleton, Bone bone) {
        if (boneData == null) {
            throw new IllegalArgumentException("data cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.data = boneData;
        this.skeleton = skeleton;
        this.parent = bone;
        this.setToSetupPose();
    }

    public Bone(Bone bone, Skeleton skeleton, Bone bone2) {
        if (bone == null) {
            throw new IllegalArgumentException("bone cannot be null.");
        }
        if (skeleton == null) {
            throw new IllegalArgumentException("skeleton cannot be null.");
        }
        this.skeleton = skeleton;
        this.parent = bone2;
        this.data = bone.data;
        this.x = bone.x;
        this.y = bone.y;
        this.rotation = bone.rotation;
        this.scaleX = bone.scaleX;
        this.scaleY = bone.scaleY;
        this.shearX = bone.shearX;
        this.shearY = bone.shearY;
    }

    @Override
    public void update() {
        this.updateWorldTransform(this.x, this.y, this.rotation, this.scaleX, this.scaleY, this.shearX, this.shearY);
    }

    public void updateWorldTransform() {
        this.updateWorldTransform(this.x, this.y, this.rotation, this.scaleX, this.scaleY, this.shearX, this.shearY);
    }

    public void updateWorldTransform(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.ax = f;
        this.ay = f2;
        this.arotation = f3;
        this.ascaleX = f4;
        this.ascaleY = f5;
        this.ashearX = f6;
        this.ashearY = f7;
        this.appliedValid = true;
        Bone bone = this.parent;
        if (bone == null) {
            float f8 = f3 + 90.0f + f7;
            float f9 = TrigUtils.cosDeg(f3 + f6) * f4;
            float f10 = TrigUtils.cosDeg(f8) * f5;
            float f11 = TrigUtils.sinDeg(f3 + f6) * f4;
            float f12 = TrigUtils.sinDeg(f8) * f5;
            Skeleton skeleton = this.skeleton;
            if (skeleton.flipX) {
                f = -f;
                f9 = -f9;
                f10 = -f10;
            }
            if (skeleton.flipY) {
                f2 = -f2;
                f11 = -f11;
                f12 = -f12;
            }
            this.a = f9;
            this.b = f10;
            this.c = f11;
            this.d = f12;
            this.worldX = f + skeleton.x;
            this.worldY = f2 + skeleton.y;
            return;
        }
        float f13 = bone.a;
        float f14 = bone.b;
        float f15 = bone.c;
        float f16 = bone.d;
        this.worldX = f13 * f + f14 * f2 + bone.worldX;
        this.worldY = f15 * f + f16 * f2 + bone.worldY;
        switch (this.data.transformMode) {
            case normal: {
                float f17 = f3 + 90.0f + f7;
                float f18 = TrigUtils.cosDeg(f3 + f6) * f4;
                float f19 = TrigUtils.cosDeg(f17) * f5;
                float f20 = TrigUtils.sinDeg(f3 + f6) * f4;
                float f21 = TrigUtils.sinDeg(f17) * f5;
                this.a = f13 * f18 + f14 * f20;
                this.b = f13 * f19 + f14 * f21;
                this.c = f15 * f18 + f16 * f20;
                this.d = f15 * f19 + f16 * f21;
                return;
            }
            case onlyTranslation: {
                float f22 = f3 + 90.0f + f7;
                this.a = TrigUtils.cosDeg(f3 + f6) * f4;
                this.b = TrigUtils.cosDeg(f22) * f5;
                this.c = TrigUtils.sinDeg(f3 + f6) * f4;
                this.d = TrigUtils.sinDeg(f22) * f5;
                break;
            }
            case noRotationOrReflection: {
                float f23;
                float f24 = f13 * f13 + f15 * f15;
                if (f24 > 1.0E-4f) {
                    f24 = Math.abs(f13 * f16 - f14 * f15) / f24;
                    f14 = f15 * f24;
                    f16 = f13 * f24;
                    f23 = TrigUtils.atan2(f15, f13) * 57.295776f;
                } else {
                    f13 = 0.0f;
                    f15 = 0.0f;
                    f23 = 90.0f - TrigUtils.atan2(f16, f14) * 57.295776f;
                }
                float f25 = f3 + f6 - f23;
                float f26 = f3 + f7 - f23 + 90.0f;
                float f27 = TrigUtils.cosDeg(f25) * f4;
                float f28 = TrigUtils.cosDeg(f26) * f5;
                float f29 = TrigUtils.sinDeg(f25) * f4;
                float f30 = TrigUtils.sinDeg(f26) * f5;
                this.a = f13 * f27 - f14 * f29;
                this.b = f13 * f28 - f14 * f30;
                this.c = f15 * f27 + f16 * f29;
                this.d = f15 * f28 + f16 * f30;
                break;
            }
            case noScale: 
            case noScaleOrReflection: {
                float f31 = TrigUtils.cosDeg(f3);
                float f32 = TrigUtils.sinDeg(f3);
                float f33 = f13 * f31 + f14 * f32;
                float f34 = f15 * f31 + f16 * f32;
                float f35 = (float)Math.sqrt(f33 * f33 + f34 * f34);
                if (f35 > 1.0E-5f) {
                    f35 = 1.0f / f35;
                }
                f33 *= f35;
                f34 *= f35;
                f35 = (float)Math.sqrt(f33 * f33 + f34 * f34);
                float f36 = 1.5707964f + TrigUtils.atan2(f34, f33);
                float f37 = TrigUtils.cos(f36) * f35;
                float f38 = TrigUtils.sin(f36) * f35;
                float f39 = TrigUtils.cosDeg(f6) * f4;
                float f40 = TrigUtils.cosDeg(90.0f + f7) * f5;
                float f41 = TrigUtils.sinDeg(f6) * f4;
                float f42 = TrigUtils.sinDeg(90.0f + f7) * f5;
                this.a = f33 * f39 + f37 * f41;
                this.b = f33 * f40 + f37 * f42;
                this.c = f34 * f39 + f38 * f41;
                this.d = f34 * f40 + f38 * f42;
                if (this.data.transformMode != BoneData.TransformMode.noScaleOrReflection ? f13 * f16 - f14 * f15 < 0.0f : this.skeleton.flipX != this.skeleton.flipY) {
                    this.b = -this.b;
                    this.d = -this.d;
                }
                return;
            }
        }
        if (this.skeleton.flipX) {
            this.a = -this.a;
            this.b = -this.b;
        }
        if (this.skeleton.flipY) {
            this.c = -this.c;
            this.d = -this.d;
        }
    }

    public void setToSetupPose() {
        BoneData boneData = this.data;
        this.x = boneData.x;
        this.y = boneData.y;
        this.rotation = boneData.rotation;
        this.scaleX = boneData.scaleX;
        this.scaleY = boneData.scaleY;
        this.shearX = boneData.shearX;
        this.shearY = boneData.shearY;
    }

    public BoneData getData() {
        return this.data;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public Bone getParent() {
        return this.parent;
    }

    public Array<Bone> getChildren() {
        return this.children;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        this.x = f;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        this.y = f;
    }

    public void setPosition(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float f) {
        this.rotation = f;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float f) {
        this.scaleX = f;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float f) {
        this.scaleY = f;
    }

    public void setScale(float f, float f2) {
        this.scaleX = f;
        this.scaleY = f2;
    }

    public void setScale(float f) {
        this.scaleX = f;
        this.scaleY = f;
    }

    public float getShearX() {
        return this.shearX;
    }

    public void setShearX(float f) {
        this.shearX = f;
    }

    public float getShearY() {
        return this.shearY;
    }

    public void setShearY(float f) {
        this.shearY = f;
    }

    public float getA() {
        return this.a;
    }

    public float getB() {
        return this.b;
    }

    public float getC() {
        return this.c;
    }

    public float getD() {
        return this.d;
    }

    public float getWorldX() {
        return this.worldX;
    }

    public float getWorldY() {
        return this.worldY;
    }

    public float getWorldRotationX() {
        return TrigUtils.atan2(this.c, this.a) * 57.295776f;
    }

    public float getWorldRotationY() {
        return TrigUtils.atan2(this.d, this.b) * 57.295776f;
    }

    public float getWorldScaleX() {
        return (float)Math.sqrt(this.a * this.a + this.c * this.c);
    }

    public float getWorldScaleY() {
        return (float)Math.sqrt(this.b * this.b + this.d * this.d);
    }

    public float worldToLocalRotationX() {
        Bone bone = this.parent;
        if (bone == null) {
            return this.arotation;
        }
        return TrigUtils.atan2(bone.a * this.c - bone.c * this.a, bone.d * this.a - bone.b * this.c) * 57.295776f;
    }

    public float worldToLocalRotationY() {
        Bone bone = this.parent;
        if (bone == null) {
            return this.arotation;
        }
        return TrigUtils.atan2(bone.a * this.d - bone.c * this.b, bone.d * this.b - bone.b * this.d) * 57.295776f;
    }

    public void rotateWorld(float f) {
        float f2 = TrigUtils.cosDeg(f);
        float f3 = TrigUtils.sinDeg(f);
        this.a = f2 * this.a - f3 * this.c;
        this.b = f2 * this.b - f3 * this.d;
        this.c = f3 * this.a + f2 * this.c;
        this.d = f3 * this.b + f2 * this.d;
        this.appliedValid = false;
    }

    void updateAppliedTransform() {
        this.appliedValid = true;
        Bone bone = this.parent;
        if (bone == null) {
            this.ax = this.worldX;
            this.ay = this.worldY;
            this.arotation = TrigUtils.atan2(this.c, this.a) * 57.295776f;
            this.ascaleX = (float)Math.sqrt(this.a * this.a + this.c * this.c);
            this.ascaleY = (float)Math.sqrt(this.b * this.b + this.d * this.d);
            this.ashearX = 0.0f;
            this.ashearY = TrigUtils.atan2(this.a * this.b + this.c * this.d, this.a * this.d - this.b * this.c) * 57.295776f;
            return;
        }
        float f = bone.a;
        float f2 = bone.b;
        float f3 = bone.c;
        float f4 = bone.d;
        float f5 = 1.0f / (f * f4 - f2 * f3);
        float f6 = this.worldX - bone.worldX;
        float f7 = this.worldY - bone.worldY;
        this.ax = f6 * f4 * f5 - f7 * f2 * f5;
        this.ay = f7 * f * f5 - f6 * f3 * f5;
        float f8 = f5 * f4;
        float f9 = f5 * f;
        float f10 = f5 * f2;
        float f11 = f5 * f3;
        float f12 = f8 * this.a - f10 * this.c;
        float f13 = f8 * this.b - f10 * this.d;
        float f14 = f9 * this.c - f11 * this.a;
        float f15 = f9 * this.d - f11 * this.b;
        this.ashearX = 0.0f;
        this.ascaleX = (float)Math.sqrt(f12 * f12 + f14 * f14);
        if (this.ascaleX > 1.0E-4f) {
            float f16 = f12 * f15 - f13 * f14;
            this.ascaleY = f16 / this.ascaleX;
            this.ashearY = TrigUtils.atan2(f12 * f13 + f14 * f15, f16) * 57.295776f;
            this.arotation = TrigUtils.atan2(f14, f12) * 57.295776f;
        } else {
            this.ascaleX = 0.0f;
            this.ascaleY = (float)Math.sqrt(f13 * f13 + f15 * f15);
            this.ashearY = 0.0f;
            this.arotation = 90.0f - TrigUtils.atan2(f15, f13) * 57.295776f;
        }
    }

    public Matrix3 getWorldTransform(Matrix3 matrix3) {
        if (matrix3 == null) {
            throw new IllegalArgumentException("worldTransform cannot be null.");
        }
        float[] fArray = matrix3.val;
        fArray[0] = this.a;
        fArray[3] = this.b;
        fArray[1] = this.c;
        fArray[4] = this.d;
        fArray[6] = this.worldX;
        fArray[7] = this.worldY;
        fArray[2] = 0.0f;
        fArray[5] = 0.0f;
        fArray[8] = 1.0f;
        return matrix3;
    }

    public Vector2 worldToLocal(Vector2 vector2) {
        float f = 1.0f / (this.a * this.d - this.b * this.c);
        float f2 = vector2.x - this.worldX;
        float f3 = vector2.y - this.worldY;
        vector2.x = f2 * this.d * f - f3 * this.b * f;
        vector2.y = f3 * this.a * f - f2 * this.c * f;
        return vector2;
    }

    public Vector2 localToWorld(Vector2 vector2) {
        float f = vector2.x;
        float f2 = vector2.y;
        vector2.x = f * this.a + f2 * this.b + this.worldX;
        vector2.y = f * this.c + f2 * this.d + this.worldY;
        return vector2;
    }

    public String toString() {
        return this.data.name;
    }
}

