/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.compression.rangecoder;

import com.badlogic.gdx.utils.compression.rangecoder.Decoder;
import java.io.IOException;

public class BitTreeDecoder {
    short[] Models;
    int NumBitLevels;

    public BitTreeDecoder(int numBitLevels) {
        this.NumBitLevels = numBitLevels;
        this.Models = new short[1 << numBitLevels];
    }

    public void Init() {
        Decoder.InitBitModels(this.Models);
    }

    public int Decode(Decoder rangeDecoder) throws IOException {
        int m = 1;
        int bitIndex = this.NumBitLevels;
        while (bitIndex != 0) {
            m = (m << 1) + rangeDecoder.DecodeBit(this.Models, m);
            --bitIndex;
        }
        return m - (1 << this.NumBitLevels);
    }

    public int ReverseDecode(Decoder rangeDecoder) throws IOException {
        int m = 1;
        int symbol = 0;
        int bitIndex = 0;
        while (bitIndex < this.NumBitLevels) {
            int bit = rangeDecoder.DecodeBit(this.Models, m);
            m <<= 1;
            m += bit;
            symbol |= bit << bitIndex;
            ++bitIndex;
        }
        return symbol;
    }

    public static int ReverseDecode(short[] Models, int startIndex, Decoder rangeDecoder, int NumBitLevels) throws IOException {
        int m = 1;
        int symbol = 0;
        int bitIndex = 0;
        while (bitIndex < NumBitLevels) {
            int bit = rangeDecoder.DecodeBit(Models, startIndex + m);
            m <<= 1;
            m += bit;
            symbol |= bit << bitIndex;
            ++bitIndex;
        }
        return symbol;
    }
}

