/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.compression;

public class CRC {
    public static int[] Table = new int[256];
    int _value = -1;

    static {
        int i = 0;
        while (i < 256) {
            int r = i;
            int j = 0;
            while (j < 8) {
                r = (r & 1) != 0 ? r >>> 1 ^ 0xEDB88320 : (r >>>= 1);
                ++j;
            }
            CRC.Table[i] = r;
            ++i;
        }
    }

    public void Init() {
        this._value = -1;
    }

    public void Update(byte[] data, int offset, int size) {
        int i = 0;
        while (i < size) {
            this._value = Table[(this._value ^ data[offset + i]) & 0xFF] ^ this._value >>> 8;
            ++i;
        }
    }

    public void Update(byte[] data) {
        int size = data.length;
        int i = 0;
        while (i < size) {
            this._value = Table[(this._value ^ data[i]) & 0xFF] ^ this._value >>> 8;
            ++i;
        }
    }

    public void UpdateByte(int b) {
        this._value = Table[(this._value ^ b) & 0xFF] ^ this._value >>> 8;
    }

    public int GetDigest() {
        return ~this._value;
    }
}

