/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.model.NodeKeyframe;
import com.badlogic.gdx.graphics.g3d.utils.AnimationController;
import com.badlogic.gdx.graphics.g3d.utils.BaseAnimationController;
import com.badlogic.gdx.utils.Array;
import org.junit.Assert;
import org.junit.Test;

public class AnimationControllerTest {
    @Test
    public void testGetFirstKeyframeIndexAtTimeNominal() {
        Array<NodeKeyframe<NodeKeyframe<String>>> keyFrames = new Array<NodeKeyframe<NodeKeyframe<String>>>();
        keyFrames.add(new NodeKeyframe<String>(0.0f, "1st"));
        keyFrames.add(new NodeKeyframe<String>(3.0f, "2nd"));
        keyFrames.add(new NodeKeyframe<String>(12.0f, "3rd"));
        keyFrames.add(new NodeKeyframe<String>(13.0f, "4th"));
        Assert.assertEquals((long)0L, (long)BaseAnimationController.getFirstKeyframeIndexAtTime(keyFrames, -1.0f));
        Assert.assertEquals((long)0L, (long)BaseAnimationController.getFirstKeyframeIndexAtTime(keyFrames, 0.0f));
        Assert.assertEquals((long)0L, (long)BaseAnimationController.getFirstKeyframeIndexAtTime(keyFrames, 2.0f));
        Assert.assertEquals((long)1L, (long)BaseAnimationController.getFirstKeyframeIndexAtTime(keyFrames, 9.0f));
        Assert.assertEquals((long)2L, (long)BaseAnimationController.getFirstKeyframeIndexAtTime(keyFrames, 12.5f));
        Assert.assertEquals((long)2L, (long)BaseAnimationController.getFirstKeyframeIndexAtTime(keyFrames, 13.0f));
        Assert.assertEquals((long)0L, (long)BaseAnimationController.getFirstKeyframeIndexAtTime(keyFrames, 14.0f));
    }

    @Test
    public void testGetFirstKeyframeIndexAtTimeSingleKey() {
        Array<NodeKeyframe<NodeKeyframe<String>>> keyFrames = new Array<NodeKeyframe<NodeKeyframe<String>>>();
        keyFrames.add(new NodeKeyframe<String>(10.0f, "1st"));
        Assert.assertEquals((long)0L, (long)BaseAnimationController.getFirstKeyframeIndexAtTime(keyFrames, 9.0f));
        Assert.assertEquals((long)0L, (long)BaseAnimationController.getFirstKeyframeIndexAtTime(keyFrames, 10.0f));
        Assert.assertEquals((long)0L, (long)BaseAnimationController.getFirstKeyframeIndexAtTime(keyFrames, 11.0f));
    }

    @Test
    public void testGetFirstKeyframeIndexAtTimeEmpty() {
        Array keyFrames = new Array();
        Assert.assertEquals((long)0L, (long)BaseAnimationController.getFirstKeyframeIndexAtTime(keyFrames, 3.0f));
    }

    private static void assertSameAnimation(Animation expected, AnimationController.AnimationDesc actual) {
        if (!expected.id.equals(actual.animation.id)) {
            Assert.fail((String)("expected: " + expected.id + ", actual: " + actual.animation.id));
        }
    }

    @Test
    public void testEndUpActionAtDurationTime() {
        Animation loop = new Animation();
        loop.id = "loop";
        loop.duration = 1.0f;
        Animation action = new Animation();
        action.id = "action";
        action.duration = 0.2f;
        ModelInstance modelInstance = new ModelInstance(new Model());
        modelInstance.animations.add(loop);
        modelInstance.animations.add(action);
        AnimationController animationController = new AnimationController(modelInstance);
        animationController.setAnimation("loop", -1);
        AnimationControllerTest.assertSameAnimation(loop, animationController.current);
        animationController.update(1.0f);
        AnimationControllerTest.assertSameAnimation(loop, animationController.current);
        animationController.update(0.01f);
        AnimationControllerTest.assertSameAnimation(loop, animationController.current);
        animationController.action("action", 1, 1.0f, null, 0.0f);
        AnimationControllerTest.assertSameAnimation(action, animationController.current);
        animationController.update(0.2f);
        AnimationControllerTest.assertSameAnimation(loop, animationController.current);
    }

    @Test
    public void testEndUpActionAtDurationTimeReverse() {
        Animation loop = new Animation();
        loop.id = "loop";
        loop.duration = 1.0f;
        Animation action = new Animation();
        action.id = "action";
        action.duration = 0.2f;
        ModelInstance modelInstance = new ModelInstance(new Model());
        modelInstance.animations.add(loop);
        modelInstance.animations.add(action);
        AnimationController animationController = new AnimationController(modelInstance);
        animationController.setAnimation("loop", -1, -1.0f, null);
        AnimationControllerTest.assertSameAnimation(loop, animationController.current);
        animationController.update(1.0f);
        AnimationControllerTest.assertSameAnimation(loop, animationController.current);
        animationController.update(0.01f);
        AnimationControllerTest.assertSameAnimation(loop, animationController.current);
        animationController.action("action", 1, -1.0f, null, 0.0f);
        AnimationControllerTest.assertSameAnimation(action, animationController.current);
        animationController.update(0.2f);
        AnimationControllerTest.assertSameAnimation(loop, animationController.current);
    }
}

